/**************************************************************************
 *                                                                        *
 * This code has been developed by John Funnell. This software is an      *
 * implementation of a part of one or more MPEG-4 Video tools as          *
 * specified in ISO/IEC 14496-2 standard.  Those intending to use this    *
 * software module in hardware or software products are advised that its  *
 * use may infringe existing patents or copyrights, and any such use      *
 * would be at such party's own risk.  The original developer of this     *
 * software module and his/her company, and subsequent editors and their  *
 * companies (including Project Mayo), will have no liability for use of  *
 * this software or modifications or derivatives thereof.                 *
 *                                                                        *
 * Project Mayo gives users of the Codec a license to this software       *
 * module or modifications thereof for use in hardware or software        *
 * products claiming conformance to the MPEG-4 Video Standard as          *
 * described in the Open DivX license.                                    *
 *                                                                        *
 * The complete Open DivX license can be found at                         *
 * http://www.projectmayo.com/opendivx/license.php                        *
 *                                                                        *
 **************************************************************************/
/**
*  Copyright (C) 2001 - Project Mayo
 *
 * John Funnell
 *
 * DivX Advanced Research Center <darc@projectmayo.com>
**/
// yuv2rgb_altivec.h //

/* C version to be optimised */

/* Functions to add or copy the result of the iDCT into the output       */
/* frame buffer.  The "clear block" function could be absorbed into this */
/* loop (set *ouputPtr = 0 after the copy/add).                          */

//	04/19/01 - J.Leiterman - Added AltiVec Function Prototypes.


#include <inttypes.h>


#ifndef _yuv2rgb_altivec_H_
#define _yuv2rgb_altivec_H_


#ifdef __cplusplus
extern "C" {
#endif 



void avec_YV12toRGB32(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);

void avec_YV12toRGB24(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);

void avec_YV12toRGB555(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);

void avec_YV12toRGB565(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);

void avec_YV12toYUY2(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);

void avec_YV12toYV12(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);

void avec_YV12toUYVY(uint8_t *puc_y, int stride_y,
		uint8_t *puc_u, uint8_t *puc_v, int stride_uv,
		uint8_t *puc_out, int width_y, int height_y,
		unsigned int _stride_out);


void yuv2rgb_init( void );


#ifdef __cplusplus
}
#endif 


#endif //_yuv2rgb_altivec_H_
