/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_SKINS_BASE_HPP
#define _XTV_SKINS_BASE_HPP

#import <IO/Manager/IOObject.hpp>

@class GLWindow;
@class NSImage;

class SkinBase : public IOObject {

public:

    SkinBase( const string & name ) : IOObject( name , "Skin" ) {}
  
    virtual ~SkinBase() {}
    
    virtual bool createSkinForWindow( GLWindow * ) = 0;
    
    virtual bool closeSkinForWindow( GLWindow * ) = 0;
    
    virtual void update() = 0;

    virtual void toggleFullScreen( bool isFullScreen ) = 0;
    
    virtual void showTVControls() = 0;
    virtual void showPlayerControls() = 0;
    
    virtual void showControls( bool on ) = 0;
    
    virtual NSImage * getWindowBackgroundImage() = 0;
};

#endif // _XTV_SKINS_BASE_HPP