/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_SKINS_DEFAULT_SKIN_HPP
#define _XTV_SKINS_DEFAULT_SKIN_HPP

#import <AppKit/AppKit.h>
#import <skins/SkinBase.hpp>

@class ControlWindow;
@class MyButton;

class DefaultSkin : public SkinBase {

public:

    DefaultSkin();
    
    ~DefaultSkin();

    virtual bool command( const string & command, const string & param1 = "", const string & param2 = "", const string & param3 = "" );

    virtual bool createSkinForWindow( GLWindow * );    
    virtual bool closeSkinForWindow ( GLWindow * );
    
    virtual void update();

    virtual void toggleFullScreen( bool isFullScreen );
    
    virtual void showTVControls();
    virtual void showPlayerControls();

    virtual void showControls( bool on );

    NSImage * getWindowBackgroundImage();    
    
protected:


private:
    
    void updateWindowSize();
    void updateControls();
    void removeControls( NSWindow * win );
    void showButton( MyButton * b, NSWindow * win );

    NSImage * loadImage( const string & name );

    virtual void createControls();
    
    MyButton * createButton( const char * aName, NSRect aRect, NSImage * image, NSImage * alternateImage );

    GLWindow  *  mWindow;
    NSWindow  * mControlWindow;
    
    MyButton * mForward;
    MyButton * mFastForward;
    MyButton * mBackward;
    MyButton * mFastBackward;
    MyButton * mStop;
    MyButton * mPause1;
    MyButton * mPause2;
    MyButton * mZoom1;
    MyButton * mZoom2;
    MyButton * mExit;
    MyButton * mDrag;
    MyButton * mUp;
    MyButton * mDown;
    MyButton * mRecord;
    MyButton * mBegin;
    MyButton * mEnd;
    MyButton * mPlayList1;
    MyButton * mPlayList2;
    MyButton * mMovie;
    
    bool       mShowControls;
    int        mMode;
};

#endif // _XTV_SKINS_DEFAULT_SKIN_HPP