/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_SKINS_DEFAULT_SKIN_HPP
#define _XTV_SKINS_DEFAULT_SKIN_HPP

#import <AppKit/AppKit.h>
#import <skins/SkinBase.hpp>

@class ControlWindow;
@class AquaButton;

class AquaSkin : public SkinBase {

public:

    AquaSkin();
    
    ~AquaSkin();

    virtual bool command( const string & command, const string & param1 = "", const string & param2 = "", const string & param3 = "" );

    virtual bool createSkinForWindow( GLWindow * );    
    virtual bool closeSkinForWindow ( GLWindow * );
    
    virtual void update();
    void AquaSkin::drawRoundedWindow(NSRect frame);

    virtual void toggleFullScreen( bool isFullScreen );
    
    virtual void showTVControls();
    virtual void showPlayerControls();

    virtual void showControls( bool on );

    NSImage * getWindowBackgroundImage();    
    
protected:


private:
    
    void updateWindowSize();
    void updateControls();
    void removeControls( NSWindow * win );
    void showButton( AquaButton * b, NSWindow * win );

    NSImage * loadImage( const string & name );

    virtual void createControls();
    
    AquaButton * createButton( const char * aName, NSRect aRect, NSImage * image, NSImage * alternateImage );
    AquaButton * createButton2( const char * aName, NSRect aRect, NSImage * image, NSImage * alternateImage );

    GLWindow  *  mWindow;
    NSWindow  * mControlWindow;
    
    AquaButton * mForward;
    AquaButton * mFastForward;
    AquaButton * mBackward;
    AquaButton * mFastBackward;
    AquaButton * mStop;
    AquaButton * mPause1;
    AquaButton * mPause2;
    AquaButton * mZoom1;
    AquaButton * mZoom2;
    AquaButton * mExit;
    AquaButton * mDrag;
    AquaButton * mUp;
    AquaButton * mDown;
    AquaButton * mRecord;
    AquaButton * mBegin;
    AquaButton * mEnd;
    AquaButton * mPlayList1;
    AquaButton * mPlayList2;
    AquaButton * mMovie;
    
    bool       mShowControls;
    int        mMode;
};

#endif // _XTV_SKINS_DEFAULT_SKIN_HPP