/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <Foundation/Foundation.h>
#import <CoreAudio/AudioHardware.h>
#import <pthread.h>
#import <objc/List.h>


#define OUTPUT_BUFFER_SIZE 8*1024



@interface Buffer : NSObject
{
    char * m_data;
    int    m_size;
    int    m_nr;
}

+(Buffer*) initWithData:(char*) _data size:(int) _size;

+(Buffer*) initWithBlock:(char*) _data size:(int) _size;

- (char*) data;
- (int) size;
- (int) nr;

@end

@interface BufferList : NSObject
{
    List *             	mBuffers;
    pthread_mutex_t 	mMutex;
    pthread_cond_t 	mCondition;
}

- (void) write:(void*)data size:(int) size;
-(Buffer*) read;
- (int) buffers;
- (void) discard;

@end

@interface xtvaudio : NSObject
{

    AudioDeviceID                mOutput;
    AudioDeviceID                mInput;
    AudioStreamBasicDescription  mOutDeviceFormat;
    UInt32                       mOutputBufferSize;
    BufferList                 * mBuffers;

}

- (int) getAudioDevices:(Ptr*) devices devicesAvailable:(short*) devicesAvailable;
- (BOOL) open:(AudioDeviceID) dev rate:(int) rate numChannels:(int) nch isOut:(BOOL) isOut;
- (void) start;
- (void) stop;
- (void) write:(void*)data size:(int) size;
-(Buffer*) read;
- (int) buffers;
- (int) bufferSize;
+ (xtvaudio*) new;

- (void)setVolume:(int )l right:(int)r;
- (void)getVolume:(int *)l right:(int *)r;

@end
