/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#import  <Cocoa/Cocoa.h>
#import <sys/signal.h>

#import "mixer/xtvaudio.h"
#import "lib/Preferences.h"

//#define USE_TIMER_HACK 1
//#define USE_FGREP_HACK 1

static xtvaudio * audioOutput = 0;
static int        sig_caught  = 0;

static void sig_catcher( int sig ) 
{
    printf( "caught signal %d\n", sig );
 
    switch( sig ) {
    case SIGINT:
    case SIGHUP:
    case SIGQUIT:
    case SIGTERM:
        sig_caught = 1;
    }   
}

static void setup_signals()
{
    signal( SIGINT,  sig_catcher );
    signal( SIGHUP,  sig_catcher );
    signal( SIGQUIT, sig_catcher );
    signal( SIGTERM, sig_catcher );
}


int run_fgrep()
{
    int nLines = 0;

    system( "fgrep -c numSampleFramesPerBuffer /var/log/system.log > /tmp/xtv.hack" );
    
    {
    
        FILE * fp = fopen( "/tmp/xtv.hack", "r" );
        
        if( fp ) {
        
            fscanf( fp, "%d", &nLines );
            
            printf( "found %d occurences\n", nLines );
        }
        fclose( fp );
    }
    
    return nLines;
}
int main( int argc, const char ** argv )
{
    int input  = -1;
    int output = -1;
    int hack1Lines, hack2Lines;

    puts( "mixer starting" );
    fflush( stdout );
    
    {
        CFStringRef inputStr = CFPreferencesCopyAppValue(CFSTR("Sound.AudioInputDeviceID"), CFSTR("xtv"));
        CFStringRef outputStr = CFPreferencesCopyAppValue(CFSTR("Sound.AudioOutputDeviceID"), CFSTR("xtv"));
       
        input = [inputStr intValue];
        output = [outputStr intValue];
    }
    
    audioOutput   = [ xtvaudio new ];
    
    printf( "input(%d) output(%d)\n", input,output );
    
    if( input != -1 && output != -1 ) {

#if defined USE_TIMER_HACK
    
        int start = time(0);
#endif

        setup_signals();
        
        usleep( 250 * 1000 );
        
        [ audioOutput open:input  rate:44100 numChannels:2 isOut:NO  ];
        [ audioOutput open:output rate:44100 numChannels:2 isOut:YES ];
 
        [ audioOutput start ];

#if defined USE_FGREP_HACK

        hack1Lines = run_fgrep();
#endif
        
        while( ! sig_caught ) {
        
            usleep( 500 * 1000 );

#if defined USE_FGREP_HACK
            
            hack2Lines = run_fgrep();
            
            if( hack2Lines > hack1Lines ) {

                puts("restart audio" );
                
                [ audioOutput stop ];
                [ audioOutput start ];
                
                hack1Lines = run_fgrep();;
            }
#elif defined USE_TIMER_HACK

            {                
                int stop = time(0);
                
                if( stop - start > 1 ) {

                    puts("restart audio" );
                    
                    [ audioOutput stop ];
                    [ audioOutput start ];
                    
                    start = stop;
                }
            }
#endif
        }
        
        [ audioOutput stop ];
    }
    return 0;
}