/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <Foundation/Foundation.h>
#include <pthread.h>

#define USE_PTHREADS
//#define DEBUG_STACK
//#define DEBUG_LOCKS

typedef struct _BufferEntry
{
  void *buffer;
  int len;
} BufferEntry;

@interface BufferStack : NSObject
{
  BufferEntry **stack;
  int size;
  int stack_length;
  int buffer_size;
  BOOL stopped;
  BOOL waitingForFinish;

#ifdef USE_PTHREADS
  pthread_mutex_t mutex;
  pthread_cond_t condition;
#else
  NSConditionLock *clock;
#endif

}

- initWithSize:(int)ssize bufferSize:(int)bsize;

- (void)push:(const void *)buffer length:(int)len;
- (void *)pop;
- (void)stop;
- (void)waitTillDone;
- (void)cancelWrite;
- (void)flush;
- (int)length;

@end
