// Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
// 
// based on :
/////////////////////////////////////////////////////////////////////////////
// settings.h
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2000 John Adcock.  All rights reserved.
/////////////////////////////////////////////////////////////////////////////
//
//	This file is subject to the terms of the GNU General Public License as
//	published by the Free Software Foundation.  A copy of this license is
//	included with this software distribution in the file COPYING.  If you
//	do not have a copy, you may obtain a copy by writing to the Free
//	Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
//	This software is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details
/////////////////////////////////////////////////////////////////////////////
//
// This software was based on Multidec 5.6 Those portions are
// Copyright (C) 1999/2000 Espresso (echter_espresso@hotmail.com)
//
/////////////////////////////////////////////////////////////////////////////
// Change Log
//
// Date          Developer             Changes
//
// 24 Jul 2000   John Adcock           Original Release
//                                     Translated most code from German
//                                     Combined Header files
//                                     Cut out all decoding
//                                     Cut out digital hardware stuff
//
// 21 Dec 2000   John Adcock           Added function to setup ini file name
//
// 05 Jan 2001   John Adcock           Added GetRefreshRate
//
/////////////////////////////////////////////////////////////////////////////


#ifndef __SETTINGS_H___
#define __SETTINGS_H___

#if defined __cplusplus
extern "C" {
#endif

#include "bt848.h"

typedef enum
{
	NOT_PRESENT = 0,
	YESNO,
	ITEMFROMLIST,
	SLIDER,
	NUMBER,
	SUBMENU,

} SETTING_TYPE;

/* Function called when setting value changes
   return value indicates whether.rest of screen needs to be
   refreshed
*/

typedef int (SETTING_ONCHANGE)(long NewValue);

typedef struct
{
	char* szDisplayName;
	SETTING_TYPE Type;
	long OriginalValue;
	long* pValue;
	long Default;
	long MinValue;
	long MaxValue;
	long StepValue;
	char** pszList;
	char* szIniSection;
	char* szIniEntry;
	SETTING_ONCHANGE* pfnOnChange;
} SETTING;

 
void LoadSettingsFromIni();
void WriteSettingsToIni();



#if defined __cplusplus
}
#endif

#endif /* __SETTINGS_H___ */