// Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
// 
// based on:
//
/////////////////////////////////////////////////////////////////////////////
// Settings.c
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2000 John Adcock.  All rights reserved.
/////////////////////////////////////////////////////////////////////////////
//
//	This file is subject to the terms of the GNU General Public License as
//	published by the Free Software Foundation.  A copy of this license is
//	included with this software distribution in the file COPYING.  If you
//	do not have a copy, you may obtain a copy by writing to the Free
//	Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
//	This software is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details
/////////////////////////////////////////////////////////////////////////////
// Change Log
//
// Date          Developer             Changes
//
// 24 Jul 2000   John Adcock           changed to windows Ini file functions
//
//  3 Nov 2000   Michael Eskin         Added override of initial BDELAY setting
//               Conexant Systems      by adding non-zero InitialBDelay in .ini
//                                     File. Changed NTSC defaults to 0x5C
//
// 21 Dec 2000   John Adcock           Added function to setup ini file name
//
// 26 Dec 2000   Eric Schmidt          Fixed remember-last-channel-on-startup.
//
// 05 Jan 2001   John Adcock           Added GetRefreshRate function
//                                     Added DoAccurateFlips parameter
//                                     Added gPALFilmFallbackMode setting
//
// 07 Jan 2001   John Adcock           Added gNTSCFilmFallbackMode setting
//                                     Changed saving of gPulldownMode
//                                     so that we don't ever restart in film mode
//                                     when we're doing autodetect  
//
// 08 Jan 2001   John Adcock           Global Variable Tidy up
//                                     Got rid of global.h structs.h defines.h
//
// 08 Jan 2001   John Adcock           Made all ini file reads use initial values
//                                     of variables rather than hardcoded values here
//
/////////////////////////////////////////////////////////////////////////////

#include "bt848.h"
#include "settings.h"
#include "tuner.h"
#include "Audio.h"
#include "TVCards.h"
#import <lib/Preferences.h>
#include <limits.h>
#include <stdio.h>


int System_In_Mute = 0;
extern int bSaveSettings;

void LoadSettingsFromIni()
{
	char szKey[128];
	int i;

	AudioSource = GetPrivateProfileInt("Sound", "AudioSource", AudioSource);
	System_In_Mute = (GetPrivateProfileInt("Sound", "System_In_Mute", System_In_Mute) != 0);
			
	MSPMode = GetPrivateProfileInt("MSP", "MSPMode", MSPMode);	
	MSPMajorMode = GetPrivateProfileInt("MSP", "MSPMajorMode", MSPMajorMode);	
	MSPMinorMode = GetPrivateProfileInt("MSP", "MSPMinorMode", MSPMinorMode);	
	MSPStereo = GetPrivateProfileInt("MSP", "MSPStereo", MSPStereo);	
	AutoStereoSelect = (GetPrivateProfileInt("MSP", "MSPAutoStereo", AutoStereoSelect) != 0);	
	InitialVolume = GetPrivateProfileInt("MSP", "Volume", InitialVolume);	
	InitialSpatial = GetPrivateProfileInt("MSP", "Spatial", InitialSpatial);	
	InitialLoudness = GetPrivateProfileInt("MSP", "Loudness", InitialLoudness);	
	InitialBass = GetPrivateProfileInt("MSP", "Bass", InitialBass);	
	InitialTreble = GetPrivateProfileInt("MSP", "Treble", InitialTreble);	
	InitialBalance = GetPrivateProfileInt("MSP", "Balance", InitialBalance);	
	InitialSuperBass = (GetPrivateProfileInt("MSP", "SuperBass", InitialSuperBass) != 0);	

	for(i = 0; i < 5; i++)
	{
		sprintf(szKey, "Equalizer%d", i + 1);
		InitialEqualizer[i] = GetPrivateProfileInt("MSP", szKey, 0);
	}
#if 0
	USE_MIXER = (GetPrivateProfileInt("Mixer", "UseMixer", USE_MIXER) != 0);	
	MIXER_LINKER_KANAL = GetPrivateProfileInt("Mixer", "VolLeftChannel", MIXER_LINKER_KANAL);
	MIXER_RECHTER_KANAL = GetPrivateProfileInt("Mixer", "VolRightChannel", MIXER_RECHTER_KANAL); 
	Volume.SoundSystem = GetPrivateProfileInt("Mixer", "VolumeSoundSystem", Volume.SoundSystem);
	Volume.Destination = GetPrivateProfileInt("Mixer", "VolumeDestination", Volume.Destination);
	Volume.Connection = GetPrivateProfileInt("Mixer", "VolumeConnection", Volume.Connection);
	Volume.Control = GetPrivateProfileInt("Mixer", "VolumeControl", Volume.Control);

	Mute.SoundSystem = GetPrivateProfileInt("Mixer", "MuteSoundSystem", Mute.SoundSystem);
	Mute.Destination = GetPrivateProfileInt("Mixer", "MuteDestination", Mute.Destination);
	Mute.Connection = GetPrivateProfileInt("Mixer", "MuteConnection", Mute.Connection);
	Mute.Control = GetPrivateProfileInt("Mixer", "MuteControl", Mute.Control);

	for(i = 0; i < 64; i++)
	{
		sprintf(szKey, "MixerSettings%d", i + 1);
		MixerLoad[i].MixerAccess.SoundSystem = GetPrivateProfileInt(szKey, "SoundSystem", -1);
		if(MixerLoad[i].MixerAccess.SoundSystem == -1)
		{
			MixerLoad[i].MixerAccess.Destination = 0;
			MixerLoad[i].MixerAccess.Connection = 0;
			MixerLoad[i].MixerAccess.Control = 0;
			MixerLoad[i].MixerValues.Kanal1 = 0;
			MixerLoad[i].MixerValues.Kanal2 = 0;
			MixerLoad[i].MixerValues.Kanal3 = 0;
			MixerLoad[i].MixerValues.Kanal4 = 0;
		}
		else
		{
			MixerLoad[i].MixerAccess.Destination = GetPrivateProfileInt(szKey, "Destination", 0);
			MixerLoad[i].MixerAccess.Connection = GetPrivateProfileInt(szKey, "Connection", 0);
			MixerLoad[i].MixerAccess.Control = GetPrivateProfileInt(szKey, "Control", 0);
			MixerLoad[i].MixerValues.Kanal1 = GetPrivateProfileInt(szKey, "Channel1", 0);
			MixerLoad[i].MixerValues.Kanal2 = GetPrivateProfileInt(szKey, "Channel2", 0);
			MixerLoad[i].MixerValues.Kanal3 = GetPrivateProfileInt(szKey, "Channel3", 0);
			MixerLoad[i].MixerValues.Kanal4 = GetPrivateProfileInt(szKey, "Channel4", 0);
		}
	}
#endif

}

