// Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
// 
// based on alevt

#ifndef VBI_H
#define VBI_H

#if defined __cplusplus
extern "C" {
#endif

#include "aletv_vt.h"
#include "aletv_lang.h"

#define PLL_ADJUST	4

struct raw_page
{
    struct vt_page page[1];
    struct enhance enh[1];
};

struct vbi
{
    // raw buffer management
    int bufsize;		// nr of bytes sent by this device
    int bpl;			// bytes per line
    u32 seq;
    // page assembly
    struct raw_page rpage[8];	// one for each magazin
    struct raw_page *ppage;	// points to page of previous pkt0
    // phase correction
    int pll_fixed;		// 0 = auto, 1..2*PLL_ADJUST+1 = fixed
    int pll_adj;
    int pll_dir;
    int pll_cnt;
    int pll_err, pll_lerr;
    // v4l2 decoder data
    int bpb;			// bytes per bit * 2^16
    int bp8bl, bp8bh;		// bytes per 8-bit low/high
    int soc, eoc;		// start/end of clock run-in
};

struct vbi *vbi_open( int fine_tune,int big_buf);
void vbi_close(struct vbi *vbi);
void vbi_reset(struct vbi *vbi);
int vbi_add_handler( void *handler, void *data);
void vbi_del_handler( void *vbi, void *handler, void *data);
struct vt_page *vbi_query_page(struct vbi *vbi, int pgno, int subno);
void vbi_pll_reset(struct vbi *vbi, int fine_tune);

#if defined __cplusplus
}
#endif

#endif
