// Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
// 
// based on alevt
#ifndef LANG_H
#define LANG_H

#include "aletv_misc.h"
#include "aletv_vt.h"

#if defined __cplusplus
extern "C" {
#endif

extern int latin1;

struct enhance
{
    int next_des;	// next expected designation code
    u32 trip[13*16];	// tripplets
};

void lang_init(void);
void conv2latin(u8 *p, int n, int lang);

void init_enhance(struct enhance *eh);
void add_enhance(struct enhance *eh, int dcode, u32 *data);
void enhance(struct enhance *eh, struct vt_page *vtp);

#if defined __cplusplus
}
#endif

#endif LANG_H
