// Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
// 
// based on alevt

#ifndef Export_H
#define Export_H

#include "aletv_vt.h"
#include "aletv_misc.h"

#if defined __cplusplus
extern "C" {
#endif

struct fmt_char
{
    u8 ch, fg, bg, attr;
};

#define EA_DOUBLE	1	// double height char
#define EA_HDOUBLE	2	// single height char in double height line
#define EA_BLINK	4	// blink
#define EA_CONCEALED	8	// concealed
#define EA_GRAPHIC	16	// graphic symbol
#define EA_SEPARATED	32	// use separated graphic symbol

#define E_DEF_FG	7
#define E_DEF_BG	0
#define E_DEF_ATTR	0

struct fmt_page
{
    struct vt_page *vtp;
    u32 dbl, hid;
    struct fmt_char data[H][W];
};

struct Export
{
    struct export_module *mod;	// module type
    char *fmt_str;		// saved option string (splitted)
    // global options
    int reveal;			// reveal hidden chars
    // local data for module's use.  initialized to 0.
    struct { int dummy; } data[0];
};

struct export_module
{
    char *fmt_name;		// the format type name (ASCII/HTML/PNG/...)
    char *extension;		// the default file name extension
    char **options;		// module options
    int local_size;
    int (*open)(struct Export *fmt);
    void (*close)(struct Export *fmt);
    int (*option)(struct Export *fmt, int opt, char *arg);
    int (*output)(struct Export *fmt, char *name, struct fmt_page *pg);
};


extern struct export_module *modules[];	// list of modules (for help msgs)
void export_error(char *str, ...);	// set error
char *export_errstr(void);		// return last error
char *export_mkname(struct Export *e, char *fmt, struct vt_page *vtp, char *usr);

struct Export *export_open(char *fmt);
void Export_close(struct Export *e);
int Export(struct Export *e, struct vt_page *vtp, char *user_str);

#if defined __cplusplus
}
#endif

#endif
