//
//  Preferences.m
//  xtv
//
//  Copyright (c) 2001 A.Thiede
//
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.


#import "Preferences.h"

#import <Cocoa/Cocoa.h>

#define USER_DEFAULTS [ NSUserDefaults standardUserDefaults ]

static NSMutableDictionary * theObserverMap = nil;

static NSObject * findObserver( NSString * key )
{
    NSEnumerator * enumerator = [ theObserverMap keyEnumerator ];
    id anId;
    
    while( ( anId = [ enumerator nextObject ] )) {
    
        if( [ key isEqualToString:(NSString*) anId ] == YES ) {
            return [ theObserverMap objectForKey:anId ];
        }
    }
    
    return nil;
}

static NSObject * findKey( NSString * key )
{
    NSEnumerator * enumerator = [ theObserverMap keyEnumerator ];
    id anId;
    
    while( ( anId = [ enumerator nextObject ] )) {
    
        if( [ key isEqualToString:(NSString*) anId ] == YES ) {
            return anId;
        }
    }
    
    return nil;
}

void postNotification( NSString * key )
{
    NSObject * observer = findObserver( key );
    
    if( observer != nil ) {
        [ observer changed ];
    }
}

void addObserver( NSObject * observer, NSString * key )
{
    if( theObserverMap == nil ) {

        theObserverMap = [ NSMutableDictionary dictionaryWithCapacity: 256 ];

        [ theObserverMap retain ];
    }
    
    if( observer != nil && key != nil ) {
        [ theObserverMap setObject:observer forKey:key ];
    }
}

void removeObserver( NSString * key )
{
    NSObject * anId = findKey( key );
    
    if( anId != nil ) {

        [ theObserverMap removeObjectForKey:anId ];
    }
}

int GetPrivateProfileInt( const char * section, const char * var, int _default ) 
{
    NSAutoreleasePool* pool =[ [ NSAutoreleasePool alloc ] init ];
    
    NSString * key = 0;
    
    int  val = _default;
    id   obj;
    char buf[1024];
    
    strcpy( buf, section );
    strcat( buf, "."     );
    strcat( buf, var     );

    key = [ NSString stringWithCString:buf ];
    
    obj = [  USER_DEFAULTS objectForKey: key ];
        
    if( obj != nil ) {

        val = [ USER_DEFAULTS integerForKey: key ];

    }

    //printf( "GetPrivateProfileInt(%s) = %d\n", buf, val );
    
    [ pool release ];
    
    return val;
}

int GetPrivateProfileString( const char * section, const char * var, const char * _default, char * result, int size ) 
{
    NSAutoreleasePool* pool =[ [ NSAutoreleasePool alloc ] init ];

    NSString * key = 0;

    const char * val = _default;
    id   obj;
    char buf[1024];
 
    strcpy( result, _default );
   
    strcpy( buf, section );
    strcat( buf, "."     );
    strcat( buf, var     );

    key = [ NSString stringWithCString:buf ];

    obj = [  USER_DEFAULTS objectForKey: key ];
        
    if( obj != nil ) {

        val = [ (NSString *) obj cString ];
        
        if( val && *val && strlen(val) < size ) {
            strcpy( result, val );
        }
    }

    //printf( "GetPrivateProfileString(%s) = %s\n", buf, val );
    
    [ pool release ];

    return true;
}

void WritePrivateProfileInt(const char * section, const char * var, int _value )
{
    NSAutoreleasePool* pool =[ [ NSAutoreleasePool alloc ] init ];

    char name [1024];
    char value[128];
    
    strcpy( name, section );
    strcat( name, "."     );
    strcat( name, var     );

    sprintf( value, "%d", _value );

    printf( "WritePrivateProfileInt(%s) = %s\n", name, value );
    
    {
    
        NSString * key = [ NSString stringWithCString : name  ];
        NSString * val = [ NSString stringWithCString : value ];
        NSString * app = [[NSBundle mainBundle ] bundleIdentifier];
    
        [ USER_DEFAULTS setObject:val forKey:key ];

        [ USER_DEFAULTS synchronize];

        //printf("appName(%s)\n", [ app cString ] );

        printf("postNotification for %s.%s\n", [ app cString ], [ key cString ] );

        //[[NSDistributedNotificationCenter defaultCenter] postNotificationName:app object:key ];
        postNotification( key );
        
    }
    [ pool release ];
    printf( "WritePrivateProfileInt(%s) = %s done\n", name, value );
}

void WritePrivateProfileString(const char * section, const char * var, const char * value )
{
    NSAutoreleasePool* pool =[ [ NSAutoreleasePool alloc ] init ];

    char name [1024];
    
    strcpy( name, section );
    strcat( name, "."     );
    strcat( name, var     );

    //printf( "WritePrivateProfileString(%s) = %s\n", name, value );
    
    {
    
        NSString * key = [ NSString stringWithCString : name  ];
        NSString * val = [ NSString stringWithCString : value ];
        NSString * app = [[NSBundle mainBundle ] bundleIdentifier];
    
        [ USER_DEFAULTS setObject:val forKey:key ];

        [ USER_DEFAULTS synchronize];

        printf("postNotification for %s.%s\n", [ app cString ], [ key cString ] );

        //[[NSDistributedNotificationCenter defaultCenter] postNotificationName:app object:key ];

        postNotification( key );

    }
    [ pool release ];
}

void RemovePrivateProfileString( const char * section, const char * var )
{
    NSAutoreleasePool* pool =[ [ NSAutoreleasePool alloc ] init ];

    NSString * key = 0;
    id   obj;
    char buf[1024];
    
    strcpy( buf, section );
    strcat( buf, "."     );
    strcat( buf, var     );

    key = [ NSString stringWithCString:buf ];

    obj = [  USER_DEFAULTS objectForKey: key ];
        
    if( obj != nil ) {

        [  USER_DEFAULTS removeObjectForKey: key ];

        [ USER_DEFAULTS synchronize];

    }

    [ pool release ];
}

const char * GetApplicationDirectory()
{
    NSAutoreleasePool* pool =[ [ NSAutoreleasePool alloc ] init ];

    static char * mainBundleDir = NULL;
    
    if( mainBundleDir == NULL ) {
    
        NSBundle * mainBundle = [ NSBundle mainBundle ];
    
        if( mainBundle != NULL ) {
        
            NSString * bundlePath = [ mainBundle bundlePath ];
                        
            if( bundlePath != NULL ) {
            
                const char * cstr = [ bundlePath cString ];

                if( cstr != NULL ) {
                    
                    mainBundleDir = (char*) malloc( strlen( cstr ) + 1 );
                    
                    strcpy( mainBundleDir, cstr );
                }
            }
        }
    }
    [ pool release ];

    return mainBundleDir;
}