#if ! defined _BT8XX_LIB_H
#define _BT8XX_LIB_H

#if defined __cplusplus
extern "C" {
#endif

#import <IOKit/IOTypes.h>

/* Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
 * 
 * based on :
 *
 * Copyright (c) 1998-2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc.  All rights reserved.
 *
 *  DRI: Josh de Cesare
 *
 */

enum eMemoryType {

    kBt8xxMemNone = 0,
    kBt8xxAudioBuffer,
    kBt8xxVideoBuffer,
    kBt8xxVBIBuffer,
};

typedef enum eMemoryType eMemoryType;

enum eCaptureFormat {
  kBtPAL    = 0,
  kBtPALCIF,
  kBtPALQCIF,
  kBtNTSC,
  kBtNTSCCIF,
  kBtNTSCQCIF,
  kBtCaptureFmtLast
};

typedef enum eCaptureFormat eCaptureFormat;

enum eBt8xxCmd {
  kBt8xxNone = 0,
  kBt8xGetDeviceID,
  kBt8xxSetup,
  kBt8xxStart,
  kBt8xxStop,
  kBt8xxSetAudioMask,
  kBt8xxReadReg8,
  kBt8xxWriteReg8,
  kBt8xxReadReg16,
  kBt8xxWriteReg16,
  kBt8xxReadReg32,
  kBt8xxWriteReg32,
  kBt8xxGetVideoBase,
  kBt8xxGetAudioBase,
  kBt8xxWait4Video,
  kBt8xxWait4VBI,
  kBt8xxReadAudio,
  kBt8xxAllocPages,
  kBt8xxFreePages,
  kBt8xxIrqWait,
  kBt8xxCount,
};

struct MemoryDescriptor {

    IOPhysicalAddress mPhysAddr;
    IOVirtualAddress  mVirtUser;
    IOVirtualAddress  mVirtKern;
    IOPhysicalLength  mLength;
    unsigned          mHandle;
};

typedef struct MemoryDescriptor MemoryDescriptor;

#ifndef KERNEL


extern kern_return_t Bt8xxGetDeviceID(mach_port_t connect, UInt32 * deviceID );

extern kern_return_t Bt8xxSetup(mach_port_t connect, UInt32 videoFmt, UInt32 colorFmt );

extern kern_return_t Bt8xxStart(mach_port_t connect);

extern kern_return_t Bt8xxStop(mach_port_t connect);

extern kern_return_t Bt8xxSetAudioMask(mach_port_t connect, UInt32 mask );

extern kern_return_t Bt8xxReadReg8 (mach_port_t connect, UInt32 reg, UInt32 * data);
extern kern_return_t Bt8xxWriteReg8(mach_port_t connect, UInt32 reg, UInt32   data);

extern kern_return_t Bt8xxReadReg16 (mach_port_t connect, UInt32 reg, UInt32 * data);
extern kern_return_t Bt8xxWriteReg16(mach_port_t connect, UInt32 reg, UInt32   data);

extern kern_return_t Bt8xxReadReg32 (mach_port_t connect, UInt32 reg, UInt32 * data);
extern kern_return_t Bt8xxWriteReg32(mach_port_t connect, UInt32 reg, UInt32   data);

extern kern_return_t Bt8xxGetVideoPhysAddr( mach_port_t connect, UInt32 * data);
extern kern_return_t Bt8xxGetAudioPhysAddr( mach_port_t connect, UInt32 * data);

extern kern_return_t Bt8xxWait4Video( io_connect_t con );
extern kern_return_t Bt8xxWait4VBI  ( io_connect_t con );
extern kern_return_t Bt8xxReadAudio( io_connect_t con, UInt32 * buffer, UInt32 count );

extern int Bt8xxMapVideoMem( io_connect_t connection, void **atAddress, unsigned int *ofSize );
extern int Bt8xxMapVBIMem  ( io_connect_t connection, void **atAddress, unsigned int *ofSize );
extern int Bt8xxMapAudioMem( io_connect_t connection, void **atAddress, unsigned int *ofSize );

extern kern_return_t Bt8xxAllocPages( mach_port_t connect, MemoryDescriptor * memoryDescriptor );
extern kern_return_t Bt8xxFreePages ( mach_port_t connect, MemoryDescriptor * memoryDescriptor );

extern kern_return_t Bt8xxIrqWait ( mach_port_t connect );


#endif

#if defined __cplusplus
}
#endif

#endif /* _BT8XX_LIB_H */
