/*
 * Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
 * 
 * based on:
 *
 * Copyright (c) 1998-2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc.  All rights reserved.
 *
 *  DRI: Josh de Cesare
 *
 */

#include <IOKit/IOKitLib.h>
#include <IOKit/iokitmig.h>

#include "Bt8xxLib.h"
#include <stdio.h>

#if ! defined NO_DEBUG

static kern_return_t check_return( kern_return_t ret, const char * func,  kern_return_t expected )
{
#if 0
    if( ret != expected ) {
        printf( "%s failed cause %d\n", func, ret );
        fflush( stdout );
    } 
#endif
    return ret;
}

#define dRETURN(ret, expected ) return check_return( ret, _dFuncName, expected );

#define dENTER( func ) const char * _dFuncName = func; 

#else
#define dRETURN(ret) return ret
#define dENTER( func )
#endif

kern_return_t Bt8xxGetDeviceID(mach_port_t connect, UInt32 * deviceID )
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxGetDeviceID");
  
  countOut = 1;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xGetDeviceID,
                                          NULL, 0,
					  (unsigned int *)deviceID, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  ); 
}

kern_return_t Bt8xxSetup(mach_port_t connect,  UInt32 videoFmt, UInt32 colorFmt  )
{  
  kern_return_t ret;
  unsigned int  countOut, dataIn[2];

  dENTER("Bt8xxSetup");
  
  dataIn[0] = videoFmt;
  dataIn[1] = colorFmt;
  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxSetup, dataIn, 2, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxStart(mach_port_t connect)
{
  kern_return_t ret;

  unsigned int  countOut;

  dENTER("Bt8xxStart");

  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxStart, NULL, 0, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxStop(mach_port_t connect)
{
  kern_return_t ret;
  
  unsigned int  countOut;

  dENTER("Bt8xxStop");

  
  countOut = 0;
  
  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxStop, NULL, 0, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxSetAudioMask(mach_port_t connect, UInt32 mask )
{
  kern_return_t ret;
  
  unsigned int  countOut;

  dENTER("Bt8xxSetAudioMask");

  
  countOut = 0;
  
  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxSetAudioMask, (unsigned int *)&mask, 1, NULL, &countOut );
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxReadReg8(mach_port_t connect,   UInt32 reg, UInt32 *data)
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxReadReg8");
  
  countOut = 1;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxReadReg8,
                                          (unsigned int *)&reg, 1,
					  (unsigned int *)data, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxWriteReg8(mach_port_t connect,  UInt32 reg, UInt32 data)
{
  kern_return_t ret;
  unsigned int  countOut, dataIn[2];

  dENTER("Bt8xxWriteReg8");
  
  dataIn[0] = reg;
  dataIn[1] = data;
  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxWriteReg8, dataIn, 2, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxReadReg16(mach_port_t connect,  UInt32 reg, UInt32 *data)
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxReadReg16");

  
  countOut = 1;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxReadReg16, (unsigned int *)&reg, 1,
					  (unsigned int *)data, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxWriteReg16(mach_port_t connect, UInt32 reg, UInt32 data)
{
  kern_return_t ret;
  unsigned int  countOut, dataIn[2];

  dENTER("Bt8xxWriteReg16");

  
  dataIn[0] = reg;
  dataIn[1] = data;
  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxWriteReg16,
                                          dataIn, 2, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxReadReg32(mach_port_t connect,  UInt32 reg, UInt32 *data)
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxReadReg32");
  
  countOut = 1;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxReadReg32,
                                          (unsigned int *)&reg, 1,
					  (unsigned int *)data, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxWriteReg32(mach_port_t connect, UInt32 reg, UInt32 data)
{
  kern_return_t ret;
  unsigned int  countOut, dataIn[2];

  dENTER("Bt8xxWriteReg32");
  
  dataIn[0] = reg;
  dataIn[1] = data;
  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxWriteReg32,
                                          dataIn, 2, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxGetVideoPhysAddr( mach_port_t connect, UInt32 * data)
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxGetVideoPhysAddr");
  
  countOut = 1;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxGetVideoBase,
                                          NULL, 0,
					  (unsigned int *)data, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxGetAudioPhysAddr( mach_port_t connect, UInt32 * data)
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxGetAudioPhysAddr");
  
  countOut = 1;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxGetAudioBase,
                                          NULL, 0,
					  (unsigned int *)data, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxWait4Video(io_connect_t connect )
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxWait4Video");
  
  countOut = 0;
 
  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxWait4Video, NULL, 0, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxWait4VBI(io_connect_t connect )
{
  kern_return_t ret;
  unsigned int  countOut;

  dENTER("Bt8xxWait4VBI");
  
  countOut = 0;
 
  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxWait4VBI, NULL, 0, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxReadAudio(io_connect_t connect, UInt32 * buffer, UInt32 count )
{
  kern_return_t ret;
  unsigned int  countOut, dataIn[2];

  dENTER("Bt8xxWait4Audio");
  
  countOut = 0;
 
  dataIn[0] = (unsigned int) buffer;
  dataIn[1] = count;
  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxReadAudio, dataIn, 2, NULL, &countOut);
  
  dRETURN( ret, count );
}

int Bt8xxMapVideoMem( io_connect_t connection, void **atAddress, unsigned int *ofSize )
{
    int ret;

  dENTER("Bt8xxMapVideoMem");
    
  ret  = (int) IOConnectMapMemory( connection,
                                     kBt8xxVideoBuffer,
                                     mach_task_self(),
                                     (vm_address_t *)atAddress,
                                     (vm_size_t *)ofSize,
                                     kIOMapAnywhere );

  dRETURN( ret, KERN_SUCCESS  );
}

int Bt8xxMapVBIMem( io_connect_t connection, void **atAddress, unsigned int *ofSize )
{
    int ret;

  dENTER("Bt8xxMapVBIMem");
    
  ret  = (int) IOConnectMapMemory( connection,
                                     kBt8xxVBIBuffer,
                                     mach_task_self(),
                                     (vm_address_t *)atAddress,
                                     (vm_size_t *)ofSize,
                                     kIOMapAnywhere );

  dRETURN( ret, KERN_SUCCESS  );
}

int Bt8xxMapAudioMem( io_connect_t connection, void **atAddress, unsigned int *ofSize )
{
  int ret;
  
  dENTER("Bt8xxMapAudioMem");

  ret = (int) IOConnectMapMemory( connection,
                                     kBt8xxAudioBuffer,
                                     mach_task_self(),
                                     (vm_address_t *)atAddress,
                                     (vm_size_t *)ofSize,
                                     kIOMapAnywhere );
  dRETURN( ret, KERN_SUCCESS  );
}

kern_return_t Bt8xxAllocPages( mach_port_t connect, MemoryDescriptor * md )
{
    kern_return_t  ret;
    unsigned int  countOut;
    
    dENTER("Bt8xxAllocPages");
    
    countOut = sizeof(MemoryDescriptor);
  
    ret = io_connect_method_scalarI_structureO(  connect, kBt8xxAllocPages,
                                                   (unsigned int *) &md->mLength,
                                                    1,
                                                   (char*) md, 
                                                    &countOut);
  
    dRETURN( ret, KERN_SUCCESS  );

}

kern_return_t Bt8xxFreePages( mach_port_t connect, MemoryDescriptor * md )
{
    kern_return_t  ret;
    unsigned int  countOut;
    
    dENTER("Bt8xxFreePages");
    
    countOut = 0;
  
    ret = io_connect_method_structureI_structureO(  connect, kBt8xxFreePages,
                                                   (char*) md,
                                                    sizeof( MemoryDescriptor),
                                                   NULL, 
                                                    &countOut);
  
    dRETURN( ret, KERN_SUCCESS  );

}

kern_return_t Bt8xxIrqWait( mach_port_t connect )
{
  kern_return_t ret;

  unsigned int  countOut;

  dENTER("Bt8xxIrqWait");

  
  countOut = 0;

  ret = io_connect_method_scalarI_scalarO(connect, kBt8xxIrqWait, NULL, 0, NULL, &countOut);
  
  dRETURN( ret, KERN_SUCCESS  );
}
