/*
    Bt8xx QuickTime driver component
    Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "QTVideoDigitizer.h"
#include "Resolvers.h"
#include <ApplicationServices/ApplicationServices.h>
#include "MiscTools.h"
#include <syslog.h>
#include <unistd.h>
#import <lib/bt848.h>
#import <lib/Bt8xxLib.h>
#import <lib/bt848.h>
#import <lib/i2c.h>
#import <lib/Tuner.h>
#import <lib/Audio.h>
#import <bt8xx/Bt8xxRegs.h>

//#define NO_REAL_HW 1

void LoadCountrySettings()
{
#if ! defined NO_REAL_HW

    char iniFile[256];
    
    int country = PreferedCountry();
        
    const char * _iniFile = "/Library/QuickTime/Bt8xx.component/Contents/Resources/Channel.txt";

    if( access( _iniFile, F_OK ) == 0 ) {
        strcpy( iniFile, _iniFile );
    }
    else {
        strcpy( iniFile, getenv("HOME") );
        strcat( iniFile, _iniFile       );
    }
        
    Load_Country_Settings( iniFile );
    
    Load_Country_Specific_Settings( iniFile, country );
#endif
}

int PreferedTuner()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Hardware.TunerType"), CFSTR("xtv"));

    return [ str intValue ];
}

static const char * itoa( int val )
{
    static char buf[64];
    
    sprintf( buf, "%d", val );
    
    return buf;
}

void SetPreferedTuner( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Hardware.TunerType"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW
    TVTuner_OnChange( val );

    AdjustColorFormat();
#endif
}

int PreferedTVType()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Hardware.TVType"), CFSTR("xtv"));

    return [ str intValue ];
}

void SetPreferedTVType( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Hardware.TVType"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW

    TVFormat_OnChange( val );

    AdjustColorFormat();

#endif
}

int PreferedChannel()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Tuner.CurrentChannel"), CFSTR("xtv"));

    return [ str intValue ];
}

void SetPreferedChannel( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Tuner.CurrentChannel"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW
    
    TuneChannel( Channels.freq[ val ] );

    AdjustColorFormat();
#endif
}

int PreferedCard()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Hardware.CardType"), CFSTR("xtv"));

    return [ str intValue ];
}

void SetPreferedCard( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Hardware.CardType"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW

    TVCard_OnChange( val );

    AdjustColorFormat();

#endif
}

int PreferedAudioSource()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Sound.AudioSource"), CFSTR("xtv"));

    return [ str intValue ];
}

void SetPreferedAudioSource( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Sound.AudioSource"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW

    Audio_SetSource( (AUDIOMUXTYPE) val );

    AdjustColorFormat();

#endif
}

int PreferedVideoSource()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Hardware.VideoSource"), CFSTR("xtv"));

    return [ str intValue ];
}

void SetPreferedVideoSource( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Hardware.VideoSource"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW

    BT848_SetVideoSource( val );

    AdjustColorFormat();

#endif
}

int PreferedCountry()
{
    CFStringRef str = CFPreferencesCopyAppValue(CFSTR("Hardware.Country"), CFSTR("xtv"));

    return [ str intValue ];
}

void SetPreferedCountry( int val )
{
    CFStringRef value = CFStringCreateWithCString( kCFAllocatorDefault, itoa(val), kCFStringEncodingASCII );
    
    CFPreferencesSetAppValue( CFSTR("Hardware.Country"), value, CFSTR("xtv") );    

    CFPreferencesAppSynchronize( CFSTR("xtv") );

#if ! defined NO_REAL_HW

    LoadCountrySettings();

    AdjustColorFormat();

#endif
}

