/*
    Bt8xx QuickTime driver component
    Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

    Based on : 

    macam - webcam app and QuickTime driver component
    Copyright (C) 2002 Matthias Krauss (macam@matthias-krauss.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define thng_RezTemplateVersion 1

#include <Carbon/Carbon.r>
#include <QuickTime/QuickTime.r>

/*

The vdig isn't registered automatically any more. It is done in the sgpn's register function. See "QT_architecture.txt" for details.
 
resource 'thng' (256) {
    'vdig',
    'wcam',
    'mk  ',
    componentHasMultiplePlatforms
    +cmpWantsRegisterMessage
    +componentDoAutoVersion
    +componentAutoVersionIncludeFlags,
    0,
    0,
    0,
    'STR ',
    256,
    'STR ',
    257,
    0,
    0,
    65537,
    componentHasMultiplePlatforms
    +cmpWantsRegisterMessage
    +componentDoAutoVersion
    +componentAutoVersionIncludeFlags,
    0,
    {
        componentHasMultiplePlatforms
        +cmpWantsRegisterMessage
        +componentDoAutoVersion
        +componentAutoVersionIncludeFlags,
        'dlle',
        256,
        platformPowerPCNativeEntryPoint,
    };
};

resource 'STR ' (256) {
    "BT848/BT878"
};

resource 'STR ' (257) {
    "A video digitizer for BT848/BT878"
};

resource 'dlle' (256) {
    "vdigMainEntry"
};
*/

resource 'thng' (258) {
    'sgpn',
    'vide',
    'mk  ',
    componentHasMultiplePlatforms
    +cmpWantsRegisterMessage
    +componentDoAutoVersion
    +componentAutoVersionIncludeFlags,
    0,
    0,
    0,
    'STR ',
    258,
    'STR ',
    259,
    0,
    0,
    65537,
    componentHasMultiplePlatforms
    +cmpWantsRegisterMessage
    +componentDoAutoVersion
    +componentAutoVersionIncludeFlags,
    0,
    {
        componentHasMultiplePlatforms
        +cmpWantsRegisterMessage
        +componentDoAutoVersion
        +componentAutoVersionIncludeFlags,
        'dlle',
        258,
        platformPowerPCNativeEntryPoint,
    };
};
    
resource 'STR ' (258) {
    "BT848/BT878"
};

resource 'STR ' (259) {
    "Specific parameter settings for the BT848/BT878 driver"
};

resource 'dlle' (258) {
    "sgpnMainEntry"
};

resource 'DITL' (258) {
{
{0,0,25,200},		/* 1: Camera name */
    StaticText {
        enabled,
        "BT848/BT878 settings"
 },

{30,0,50,300},	/* card type */
Control {
    enabled,
    1010
},

{70,0,90,300},	/* tuner type */
Control {
    enabled,
    1011
},

{110,0,130,300}, /* format pal/ntsc etc */
Control {
    enabled,
    1012
},

{150,0,170,300}, /* audio source */
Control {
    enabled,
    1013
},

{190,0,210,300}, /* video source */
Control {
    enabled,
    1014
},

{230,0,250,300},	/* country */
Control {
    enabled,
    1015
},

{270, 0,290,300},	/* channel */
Control {
    enabled,
    1016
},

}};

resource 'CNTL' (1010) {
{0,0,20,300},
    0,
    visible,
    120,
    1010,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Card:"
};

resource 'CNTL' (1011) {
{0,0,20,300},
    0,
    visible,
    120,
    1011,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Tuner:"
};

resource 'CNTL' (1012) {
{0,0,20,300},
    0,
    visible,
    120,
    1012,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Format:"
};

resource 'CNTL' (1013) {
{0,0,20,300},
    0,
    visible,
    120,
    1013,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Audio source:"
};

resource 'CNTL' (1014) {
{0,0,20,300},
    0,
    visible,
    120,
    1014,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Video source:"
};

resource 'CNTL' (1015) {
{0,0,20,300},
    0,
    visible,
    120,
    1015,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Country:"
};

resource 'CNTL' (1016) {
{0,0,20,300},
    0,
    visible,
    120,
    1016,
    kControlPopupButtonProc+kControlPopupFixedWidthVariant,
    0,
    "Channel:"
};

resource 'MENU' (1010) {
    1010,
    textMenuProc,
    allEnabled,enabled,
    "Card",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
    "10",noIcon,noKey,noMark,plain,
    "11",noIcon,noKey,noMark,plain,
    "12",noIcon,noKey,noMark,plain,
    "13",noIcon,noKey,noMark,plain,
    "14",noIcon,noKey,noMark,plain,
    "15",noIcon,noKey,noMark,plain,
    "16",noIcon,noKey,noMark,plain,
    "17",noIcon,noKey,noMark,plain,
    "18",noIcon,noKey,noMark,plain,
    "19",noIcon,noKey,noMark,plain,
    "20",noIcon,noKey,noMark,plain,
    "21",noIcon,noKey,noMark,plain,
    "22",noIcon,noKey,noMark,plain,
    "23",noIcon,noKey,noMark,plain,
    "24",noIcon,noKey,noMark,plain,
    "25",noIcon,noKey,noMark,plain,
    "26",noIcon,noKey,noMark,plain,
    "27",noIcon,noKey,noMark,plain,
    "28",noIcon,noKey,noMark,plain,
    "29",noIcon,noKey,noMark,plain,
    "30",noIcon,noKey,noMark,plain,
    "31",noIcon,noKey,noMark,plain,
    "32",noIcon,noKey,noMark,plain,
    "33",noIcon,noKey,noMark,plain,
    "34",noIcon,noKey,noMark,plain,
    "35",noIcon,noKey,noMark,plain,
    "36",noIcon,noKey,noMark,plain,
    "37",noIcon,noKey,noMark,plain,
    "38",noIcon,noKey,noMark,plain,
    "39",noIcon,noKey,noMark,plain,
    "40",noIcon,noKey,noMark,plain,
    "41",noIcon,noKey,noMark,plain,
    "42",noIcon,noKey,noMark,plain,
    "43",noIcon,noKey,noMark,plain,
    "44",noIcon,noKey,noMark,plain,
    "45",noIcon,noKey,noMark,plain,
    "46",noIcon,noKey,noMark,plain,
    "47",noIcon,noKey,noMark,plain,
    "48",noIcon,noKey,noMark,plain,
    "49",noIcon,noKey,noMark,plain,
    "50",noIcon,noKey,noMark,plain,
    "51",noIcon,noKey,noMark,plain,
    "52",noIcon,noKey,noMark,plain,
    "53",noIcon,noKey,noMark,plain,
    "54",noIcon,noKey,noMark,plain,
    "55",noIcon,noKey,noMark,plain,
    "56",noIcon,noKey,noMark,plain,
    "57",noIcon,noKey,noMark,plain,
    "58",noIcon,noKey,noMark,plain,
    "59",noIcon,noKey,noMark,plain,
}
};

resource 'MENU' (1011) {
    1011,
    textMenuProc,
    allEnabled,enabled,
    "Tuner",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
}
};

resource 'MENU' (1012) {
    1012,
    textMenuProc,
    allEnabled,enabled,
    "Format",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
}
};

resource 'MENU' (1013) {
    1013,
    textMenuProc,
    allEnabled,enabled,
    "Audio source",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
}
};

resource 'MENU' (1014) {
    1014,
    textMenuProc,
    allEnabled,enabled,
    "Video source",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
}
};

resource 'MENU' (1015) {
    1015,
    textMenuProc,
    allEnabled,enabled,
    "Country",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
}
};

resource 'MENU' (1016) {
    1016,
    textMenuProc,
    allEnabled,enabled,
    "Channel",
{
    "0",noIcon,noKey,noMark,plain,
    "1",noIcon,noKey,noMark,plain,
    "2",noIcon,noKey,noMark,plain,
    "3",noIcon,noKey,noMark,plain,
    "4",noIcon,noKey,noMark,plain,
    "5",noIcon,noKey,noMark,plain,
    "6",noIcon,noKey,noMark,plain,
    "7",noIcon,noKey,noMark,plain,
    "8",noIcon,noKey,noMark,plain,
    "9",noIcon,noKey,noMark,plain,
    "10",noIcon,noKey,noMark,plain,
    "11",noIcon,noKey,noMark,plain,
    "12",noIcon,noKey,noMark,plain,
    "13",noIcon,noKey,noMark,plain,
    "14",noIcon,noKey,noMark,plain,
    "15",noIcon,noKey,noMark,plain,
    "16",noIcon,noKey,noMark,plain,
    "17",noIcon,noKey,noMark,plain,
    "18",noIcon,noKey,noMark,plain,
    "19",noIcon,noKey,noMark,plain,
    "20",noIcon,noKey,noMark,plain,
    "21",noIcon,noKey,noMark,plain,
    "22",noIcon,noKey,noMark,plain,
    "23",noIcon,noKey,noMark,plain,
    "24",noIcon,noKey,noMark,plain,
    "25",noIcon,noKey,noMark,plain,
    "26",noIcon,noKey,noMark,plain,
    "27",noIcon,noKey,noMark,plain,
    "28",noIcon,noKey,noMark,plain,
    "29",noIcon,noKey,noMark,plain,
    "30",noIcon,noKey,noMark,plain,
    "31",noIcon,noKey,noMark,plain,
    "32",noIcon,noKey,noMark,plain,
    "33",noIcon,noKey,noMark,plain,
    "34",noIcon,noKey,noMark,plain,
    "35",noIcon,noKey,noMark,plain,
    "36",noIcon,noKey,noMark,plain,
    "37",noIcon,noKey,noMark,plain,
    "38",noIcon,noKey,noMark,plain,
    "39",noIcon,noKey,noMark,plain,
    "40",noIcon,noKey,noMark,plain,
    "41",noIcon,noKey,noMark,plain,
    "42",noIcon,noKey,noMark,plain,
    "43",noIcon,noKey,noMark,plain,
    "44",noIcon,noKey,noMark,plain,
    "45",noIcon,noKey,noMark,plain,
    "46",noIcon,noKey,noMark,plain,
    "47",noIcon,noKey,noMark,plain,
    "48",noIcon,noKey,noMark,plain,
    "49",noIcon,noKey,noMark,plain,
    "50",noIcon,noKey,noMark,plain,
    "51",noIcon,noKey,noMark,plain,
    "52",noIcon,noKey,noMark,plain,
    "53",noIcon,noKey,noMark,plain,
    "54",noIcon,noKey,noMark,plain,
    "55",noIcon,noKey,noMark,plain,
    "56",noIcon,noKey,noMark,plain,
    "57",noIcon,noKey,noMark,plain,
    "58",noIcon,noKey,noMark,plain,
    "59",noIcon,noKey,noMark,plain,
    "60",noIcon,noKey,noMark,plain,
    "61",noIcon,noKey,noMark,plain,
    "62",noIcon,noKey,noMark,plain,
    "63",noIcon,noKey,noMark,plain,
    "64",noIcon,noKey,noMark,plain,
    "65",noIcon,noKey,noMark,plain,
    "66",noIcon,noKey,noMark,plain,
    "67",noIcon,noKey,noMark,plain,
    "68",noIcon,noKey,noMark,plain,
    "69",noIcon,noKey,noMark,plain,
    "70",noIcon,noKey,noMark,plain,
    "71",noIcon,noKey,noMark,plain,
    "72",noIcon,noKey,noMark,plain,
    "73",noIcon,noKey,noMark,plain,
    "74",noIcon,noKey,noMark,plain,
    "75",noIcon,noKey,noMark,plain,
    "76",noIcon,noKey,noMark,plain,
    "77",noIcon,noKey,noMark,plain,
    "78",noIcon,noKey,noMark,plain,
    "79",noIcon,noKey,noMark,plain,
    "80",noIcon,noKey,noMark,plain,
    "81",noIcon,noKey,noMark,plain,
    "82",noIcon,noKey,noMark,plain,
    "83",noIcon,noKey,noMark,plain,
    "84",noIcon,noKey,noMark,plain,
    "85",noIcon,noKey,noMark,plain,
    "86",noIcon,noKey,noMark,plain,
    "87",noIcon,noKey,noMark,plain,
    "88",noIcon,noKey,noMark,plain,
    "89",noIcon,noKey,noMark,plain,
    "90",noIcon,noKey,noMark,plain,
    "91",noIcon,noKey,noMark,plain,
    "92",noIcon,noKey,noMark,plain,
    "93",noIcon,noKey,noMark,plain,
    "94",noIcon,noKey,noMark,plain,
    "95",noIcon,noKey,noMark,plain,
    "96",noIcon,noKey,noMark,plain,
    "97",noIcon,noKey,noMark,plain,
    "98",noIcon,noKey,noMark,plain,
    "99",noIcon,noKey,noMark,plain,
    "100",noIcon,noKey,noMark,plain,
    "101",noIcon,noKey,noMark,plain,
    "102",noIcon,noKey,noMark,plain,
    "103",noIcon,noKey,noMark,plain,
    "104",noIcon,noKey,noMark,plain,
    "105",noIcon,noKey,noMark,plain,
    "106",noIcon,noKey,noMark,plain,
    "107",noIcon,noKey,noMark,plain,
    "108",noIcon,noKey,noMark,plain,
    "109",noIcon,noKey,noMark,plain,
    "110",noIcon,noKey,noMark,plain,
    "111",noIcon,noKey,noMark,plain,
    "112",noIcon,noKey,noMark,plain,
    "113",noIcon,noKey,noMark,plain,
    "114",noIcon,noKey,noMark,plain,
    "115",noIcon,noKey,noMark,plain,
    "116",noIcon,noKey,noMark,plain,
    "117",noIcon,noKey,noMark,plain,
    "118",noIcon,noKey,noMark,plain,
    "119",noIcon,noKey,noMark,plain,
    "110",noIcon,noKey,noMark,plain,
    "111",noIcon,noKey,noMark,plain,
    "112",noIcon,noKey,noMark,plain,
    "113",noIcon,noKey,noMark,plain,
    "114",noIcon,noKey,noMark,plain,
    "115",noIcon,noKey,noMark,plain,
    "116",noIcon,noKey,noMark,plain,
    "117",noIcon,noKey,noMark,plain,
    "118",noIcon,noKey,noMark,plain,
    "119",noIcon,noKey,noMark,plain,
    "120",noIcon,noKey,noMark,plain,
    "121",noIcon,noKey,noMark,plain,
    "122",noIcon,noKey,noMark,plain,
    "123",noIcon,noKey,noMark,plain,
    "124",noIcon,noKey,noMark,plain,
    "125",noIcon,noKey,noMark,plain,
}
};
