#include <IOKit/IORegistryEntry.h>
#include <IOKit/IOLib.h>
#include <IOKit/IOService.h>
#include <IOKit/pci/IOPCIDevice.h>

extern "C" void dump_reg()
{
    const IORegistryPlane * dt = IORegistryEntry::getPlane( "IODeviceTree" );

    IOLog( "dt = %p\n", dt );

#if 0
    IORegistryEntry * pci = IORegistryEntry::fromPath(  "IODeviceTree:pci" );

    IOLog( "pci = %p\n", pci );
    
    IORegistryIterator * iter = IORegistryIterator::iterateOver( dt, kIORegistryIterateRecursively );

    if( iter ) {
    
        IOLog( "iter = %p\n", iter );
    
        IORegistryEntry * child;
        
        while( ( child = iter->getNextObject()) ) {
            
            char path[128];
            int len = sizeof(path);
            
            memset( path, 0, len );
            
            const char * name = child->getName();
            const char * loc = child->getLocation();
            
            child->getPath( path, &len, dt );
            
            IOLog( "child(%s) path(%s)\n", name, path );
        }
        
        iter->release();
    }
#endif
    
    OSIterator * pciDevices = IOService::getMatchingServices(IOService::serviceMatching("IOPCIDevice"));
    
    if( pciDevices ) {
    
        IOLog( "pciDevices(%p)\n", pciDevices );

        OSObject * tmpObject;
        
        while( tmpObject = pciDevices->getNextObject() ) {

            IOPCIDevice * pciDevice = OSDynamicCast( IOPCIDevice, tmpObject);

            if( pciDevice != 0) {

                char path[128];
                int len = sizeof(path);
            
                memset( path, 0, len );
            
                const char * name = pciDevice->getName();
                const char * loc  = pciDevice->getLocation();
            
                pciDevice->getPath( path, &len, dt );
            
                IOLog( "device(%s) path(%s)\n", name, path );
            }
        }
        
        pciDevices->release();
    }
    
#if 0

                                        const IORegistryPlane * plane = 0,
                                        char * residualPath = 0,
					int * residualLength = 0,
					IORegistryEntry * fromEntry = 0 );
                                        
    
    IORegistryIterator * iter = IORegistryIterator::iterateOver( dt );
                                                                 
    IORegistryEntry * root = IORegistryEntry::getRegistryRoot();
    
    if( root != 0 ) {
    
        OSDictionary * d = root->dictionaryWithProperties();
     
        if( d != 0 ) {
        
            OSCollectionIterator * iter = OSCollectionIterator::withCollection(d);
            
            if( iter != 0 ) {
            
                OSObject * obj;
                
                do {

                    obj = iter->getNextObject();

                } while( obj != 0 );
                
                iter->release();
            }
            
            d->release();
        }
    }
#endif
}
