/*
 * Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
 * 
 * based on:
 *
 * Copyright (c) 1998-2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc.  All rights reserved.
 *
 *  DRI: Josh de Cesare
 *
 */

#if ! defined _BT8XX_USER_CLIENT_H
#define _BT8XX_USER_CLIENT_H

#include <IOKit/IOService.h>
#include <IOKit/IOUserClient.h>
#include <IOKit/pci/IOPCIDevice.h>
#include <iokit/IOInterruptEventSource.h>
#include <IOKit/IOSyncer.h>

#include "../lib/Bt8xxLib.h"



class Bt8xxUserClient : public IOUserClient
{
  OSDeclareDefaultStructors(Bt8xxUserClient);
  
private:
  Bt8xx       * owner;
  task_t        task;
  
  IOExternalMethod externals[kBt8xxCount];
  
public:
  static Bt8xxUserClient *withTask(task_t owningTask);
  
  virtual bool start(IOService *provider);
  
  virtual IOReturn clientClose(void);
  virtual IOService *getService(void);
  virtual IOExternalMethod *getTargetAndMethodForIndex( IOService **targetP, UInt32 index );
  
  virtual IOReturn clientMemoryForType( UInt32 type, IOOptionBits * options, IOMemoryDescriptor ** memory );
  
private:

  IOReturn _extNone(void);

  IOReturn _extGetDeviceID( UInt32 * id );

  IOReturn _extSetup( UInt32 capFmt, UInt32 colFmt );

  IOReturn _extStart(void);

  IOReturn _extStop(void);

  IOReturn _extSetAudioMask(SInt32 source);

  IOReturn _extReadReg8 (UInt32 reg, UInt32 *data);
  IOReturn _extWriteReg8(UInt32 reg, UInt32  data);

  IOReturn _extReadReg16 (UInt32 reg, UInt32 *data);
  IOReturn _extWriteReg16(UInt32 reg, UInt32  data);

  IOReturn _extReadReg32 (UInt32 reg, UInt32 *data);
  IOReturn _extWriteReg32(UInt32 reg, UInt32  data);

  IOReturn _extGetVideoPhysAddr(UInt32 *source);
  IOReturn _extGetAudioPhysAddr(UInt32 *source);

  IOReturn _extWait4Video();
  IOReturn _extWait4VBI();
  IOReturn _extReadAudio( UInt32 * buffer, UInt32 swcount );

  IOReturn _extAllocPages( UInt32 nPages, MemoryDescriptor * md );
  IOReturn _extFreePages ( MemoryDescriptor * md );

  IOReturn _extIrqWait();
  
};

#endif // _BT8XX_USER_CLIENT_H
