/*
 * Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
 * 
 * based on:
 *
 * Copyright (c) 1998-2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc.  All rights reserved.
 *
 *  DRI: Josh de Cesare
 *
 */

// Device IDs
enum {
    kBtDeviceID848VF = 0x350,
    kBt848ARevision  = 0x12,
    kBtDeviceID849VF = 0x351,
    kBtDeviceID878VF = 0x368,
    kBtDeviceID878AF = 0x878,
    kBtDeviceID879VF = 0x369,
    kBtDeviceID879AF = 0x879,
    //kBtDeviceID879   = 0x36e,

};

// Video Registers
enum {
  kBtFieldEven           = 0x00,
  kBtFieldOdd            = 0x80,
  
  kBtDStatus             = 0x000,
  kBtDStatusPres         = 1 << 7,
  kBtDStatusHLoc         = 1 << 6,
  kBtDStatusField        = 1 << 5,
  kBtDStatusNumL         = 1 << 4,
  kBtDStatusPLock        = 1 << 2,
  kBtDStatusLOF          = 1 << 1,
  kBtDStatusCOF          = 1 << 0,
  
  kBtIForm               = 0x004,
  kBtIFormMuxSelMask     = 3 << 5,
  kBtIFormMuxSelSelMux3  = 0 << 5,
  kBtIFormMuxSelSelMux2  = 1 << 5,
  kBtIFormMuxSelSelMux0  = 2 << 5,
  kBtIFormMuxSelSelMux1  = 3 << 5,
  kBtIFormFormatMask     = 7 << 0,
  kBtIFormFormatAuto     = 0 << 0,
  kBtIFormFormatNTSC_M   = 1 << 0,
  kBtIFormFormatNTSC_J   = 2 << 0,
  kBtIFormFormatPAL      = 3 << 0,
  kBtIFormFormatPAL_M    = 4 << 0,
  kBtIFormFormatPAL_N    = 5 << 0,
  kBtIFormFormatSECAM    = 6 << 0,
  kBtIFormFormatPAL_Nc   = 7 << 0,
  
  kBtTDec                = 0x000,
  kBtTDecDecField        = 1 << 7,
  kBtTDecFlAlign         = 1 << 6,
  kBtTDecDecRatMask      = 0x3F,
  
  kBtCrop                = 0x00C,
  kBtCropVDelayMSBShift  = 6,
  kBtCropVDelayMSBMask   = 3 << 6,
  kBtCropVActiveMSBShift = 4,
  kBtCropVActiveMSBMask  = 3 << 4,
  kBtCropHDelayMSBShift  = 2,
  kBtCropHDelayMSBMask   = 3 << 2,
  kBtCropHActiveMSBShift = 0,
  kBtCropHActiveMSBMask  = 3 << 0,
  
  kBtVDelayLo            = 0x010,
  kBtVActiveLo           = 0x014,
  kBtHDelayLo            = 0x018,
  kBtHActiveLo           = 0x01C,
  kBtHScaleHi            = 0x020,
  kBtHScaleLo            = 0x024,
  kBtBright              = 0x028,
  
  kBtControl             = 0x02C,
  kBtControlLNotch       = 1 << 7,
  kBtControlComp         = 1 << 6,
  kBtControlLDec         = 1 << 5,
  kBtControlCBSense      = 1 << 4,
  kBtControlConMSB       = 1 << 2,
  kBtControlSatUMSB      = 1 << 1,
  kBtControlSatVMSB      = 1 << 0,
  
  kBtContrastLo          = 0x030,
  kBtSatULo              = 0x034,
  kBtSatVLo              = 0x038,
  kBtHue                 = 0x03C,
  
  kBtSCLoop              = 0x040,
  kBtSCLoopPeak          = 1 << 7,
  kBtSCLoopCAGC          = 1 << 6,
  kBtSCLoopCKill         = 1 << 5,
  kBtSCLoopHFiltMask     = 3 << 3,
  kBtSCLoopHFiltMinFull  = 0 << 3,
  kBtSCLoopHFiltMaxFull  = 1 << 3,
  kBtSCLoopHFiltMinCif   = 2 << 3,
  kBtSCLoopHFiltMaxCif   = 3 << 3,
  
  kBtWCUp                = 0x044,
  kBtWCUpMAjsMask        = 3 << 6,
  kBtWCUpMAjs3_4         = 0 << 6,
  kBtWCUpMAjs1_2         = 1 << 6,
  kBtWCUpMAjs1_4         = 2 << 6,
  kBtWCUpMAjsAuto        = 3 << 6,
  kBtWCUpUpCntMask       = 0x1F,
  
  kBtOForm               = 0x048,
  kBtOFormRange          = 1 << 7,
  kBtOFormCoreMask       = 3 << 5,
  kBtOFormCore0          = 0 << 5,
  kBtOFormCore8          = 1 << 5,
  kBtOFormCore16         = 2 << 5,
  kBtOFormCore32         = 3 << 5,
  
  kBtVScaleHi            = 0x04C,
  kBtVScaleHiVSFldAlign  = 1 << 7,
  kBtVScaleHiComb        = 1 << 6,
  kBtVScaleHiInt         = 1 << 5,
  kBtVScaleMask          = 0x1F,
  
  kBtVScaleLo            = 0x050,
  kBtTest                = 0x054,
  kBtADelay              = 0x060,
  kBtBDelay              = 0x064,
  
  kBtADC                 = 0x068,
  kBtADCReserved         = 4 << 5,
  kBtADCAGCEn            = 1 << 4,
  kBtADCClkSleep         = 1 << 3,
  kBtADCYSleep           = 1 << 2,
  kBtADCCSleep           = 1 << 1,
  kBtADCCrush            = 1 << 0,
  
  kBtVTC                 = 0x06C,
  kBtVTCHSFmt            = 1 << 7,
  kBtVTCVFiltMask        = 7 << 0,
  
  kBtWCDn                = 0x078,
  kBtWCDnVertEn          = 1 << 7,
  kBtWCDnWCFrame         = 1 << 6,
  kBtWCDnDnCntMask       = 0x3F,
  
  kBtSReset              = 0x07C,
  kBtTGLB                = 0x080,
  
  kBtTGCtrl              = 0x084,
  kBtTGCtrlTGCkOMask     = 3 << 5,
  kBtTGCtrlTGCkOClk      = 0 << 5,
  kBtTGCtrlTGCkOXTal     = 1 << 5,
  kBtTGCtrlTGCkOPLL      = 2 << 5,
  kBtTGCtrlTGCkOPLLi     = 3 << 5,
  kBtTGCtrlTGCkIMask     = 3 << 3,
  kBtTGCtrlTGCkIXTal     = 0 << 3,
  kBtTGCtrlTGCkIPLL      = 1 << 3,
  kBtTGCtrlTGCkIGPClk    = 2 << 3,
  kBtTGCtrlTGCkIGPClki   = 3 << 3,
  kBtTGCtrlTGCAI         = 1 << 2,
  kBtTGCtrlCPCAR         = 1 << 1,
  kBtTGCtrlTGVM          = 1 << 0,
  
  kBtVTotalLo            = 0x0B0,
  kBtVTotalHi            = 0x0B4,
  
  kBtColorFmt            = 0x0D4,
  kBtColorFmtOddShift    = 4,
  kBtColorFmtEvenShift   = 0,
  kBtColorFmtRGB32       = 0,
  kBtColorFmtRGB24       = 1,
  kBtColorFmtRGB16       = 2,
  kBtColorFmtRGB15       = 3,
  kBtColorFmtYUV422      = 4,
  kBtColorFmtYUV411      = 5,
  kBtColorFmtY8          = 6,
  kBtColorFmtRGB8        = 7,
  kBtColorFmtYCrCb422Pln = 8,
  kBtColorFmtYCrCb411Pln = 9,
  kBtColorFmtRaw8X       = 0xE,
  
  kBtColorCtl            = 0x0D8,
  kBtColorCtlExtFrmRate  = 1 << 7,
  kBtColorCtlColorBars   = 1 << 6,
  kBtColorCtlRGBDED      = 1 << 5,
  kBtColorCtlGamma       = 1 << 4,
  kBtColorCtlWSwapOdd    = 1 << 3,
  kBtColorCtlWSwapEven   = 1 << 2,
  kBtColorCtlBSwapOdd    = 1 << 1,
  kBtColorCtlBSwapEven   = 1 << 0,
  
  kBtCapCtl              = 0x0DC,
  kBtCapCtlDithFrame     = 1 << 4,
  kBtCapCtlCapVBIOdd     = 1 << 3,
  kBtCapCtlCapVBIEven    = 1 << 2,
  kBtCapCtlCapOdd        = 1 << 1,
  kBtCapCtlCapEven       = 1 << 0,
  
  kBtVBIPackSize         = 0x0E0,
  kBtVBIPackDel          = 0x0E4,
  kBtVBIPackDelHDelShift = 2,
  kBtVBIPackDelHDelMask  = 0x3F << 2,
  kBtVBIPackDelExtFrame  = 1 << 1,
  kBtVBIPackDelVBIPktHi  = 1 << 0,
  
  kBtFCap                = 0x0E8,
  kBtPLLFLo              = 0x0F0,
  kBtPLLFHi              = 0x0F4,
  kBtPLLXCI              = 0x0F8,
  kBtPLLXCIPLLX          = 1 << 7,
  kBtPLLXCIPLLC          = 1 << 6,
  kBtPLLXCIPLLIMask      = 0x3F,
  
  kBtDVSIF               = 0x0FC,
  kBtDVSIFVSIFBCF        = 1 << 6,
  kBtDVSIFVSIFESO        = 1 << 5,
  kBtDVSIFSVRefMask      = 3 << 3,
  kBtDVSIFSVRefAlignCb   = 0 << 3,
  kBtDVSIFSVRefAlignY0   = 1 << 3,
  kBtDVSIFSVRefAlignCr   = 2 << 3,
  kBtDVSIFSVRefAlignY1   = 3 << 3,
  kBtDVSIFVSFmtMask      = 7 << 0,
  kBtDVSIFVSFmtDisabled  = 0 << 0,
  kBtDVSIFVSFmtCCIR656   = 1 << 0,
  kBtDVSIFVSFmtExtHsVs   = 4 << 0,
  kBtDVSIFVSFmtExtHsFld  = 5 << 0,
  
  kBtIntStat             = 0x100,
  kBtIntMask             = 0x104,
  
  kBtStatusRACK          = 1 << 25,
  kBtIntAllMask          = 0xFFFFFFF,
  kBtIntIICDone          = 1 << 8,
  
  kBtGPIODMACTL          = 0x10C,
  kBtGPIODMACTLRISCEn    = 1 << 1,
  kBtGPIODMACTLFIFOEn    = 1 << 0,
  kBtGPIODMACTLDAES2     =  (1 << 13),
  kBtGPIODMACTLACAPEn    =  (1 <<  4),
  kBtGPIODMACTLAPWRDN    =  (1 << 26),
  kBtGPIODMACTLDASBR     =  (1 << 14),

  kBtIIC                 = 0x110,
  kBtIICDB0Shift         = 24,
  kBtIICDB1Shift         = 16,
  kBtIICDB2Shift         = 8,
  kBtIICModeSoftware     = 0 << 7,
  kBtIICModeHardware     = 1 << 7,
  kBtIICRate100kHz       = 0 << 6,
  kBtIICRate400kHz       = 1 << 6,
  kBtIICNoStop           = 1 << 5,
  kBtIICNoS1B            = 1 << 4,
  kBtIICSync             = 1 << 3,
  kBtIICW3BRA            = 1 << 2,
  kBtIICSCL              = 1 << 1,
  kBtIICSDA              = 1 << 0,
  
  kBtStartAddr           = 0x114,
  kBtGPIOOutEn           = 0x118,
  kBtRISCCount           = 0x11C,
  kBtGPIOData            = 0x200,


  kBtPacketLen    	=  0x110
};

// DMA Commands
enum {
  kBtDMAOpcodeMask       = 0xF << 28,
  kBtDMAOpcodeWrite      = 0x1 << 28,
  kBtDMAOpcodeWrite123   = 0x9 << 28,
  kBtDMAOpcodeWrite1S23  = 0xB << 28,
  kBtDMAOpcodeWriteC     = 0x5 << 28,
  kBtDMAOpcodeSkip       = 0x2 << 28,
  kBtDMAOpcodeSkip123    = 0xA << 28,
  kBtDMAOpcodeJump       = 0x7 << 28,
  kBtDMAOpcodeSync       = 0x8 << 28,
  
  kBtDMASOL              = 1 << 27,
  kBtDMAEOL              = 1 << 26,
  kBtDMAIRQ              = 1 << 24,
  
  kBtDMAResync           = 1 << 15,
  
  kBtDMAByteEnablesShift = 12,
  kBtDMAByteEnablesMask  = 0xF << 12,
  
  kBtDMAByteCountMask    = 0x00000FFF,
  
  kBtDMARiskStatusMask   = 0xF,
  kBtDMARiskStatusFM1    = 0x6,
  kBtDMARiskStatusFM3    = 0xE,
  kBtDMARiskStatusSOL    = 0x2,
  kBtDMARiskStatusEOL4   = 0x1,
  kBtDMARiskStatusEOL3   = 0xD,
  kBtDMARiskStatusEOL2   = 0x9,
  kBtDMARiskStatusEOL1   = 0x5,
  kBtDMARiskStatusVRE    = 0x4,
  kBtDMARiskStatusVRO    = 0xC,
  kBtDMARiskStatusPXV    = 0x0,
};
