/*
 * Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )
 * 
 * based on:
 *
 * Copyright (c) 1998-2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc.  All rights reserved.
 *
 *  DRI: Josh de Cesare
 *
 */

#include <IOKit/IOService.h>
#include <IOKit/pci/IOPCIDevice.h>
#include <iokit/IOInterruptEventSource.h>

/* forward */ class Bt8xxImpl;
/* forward */ class WorkLoop;

class Bt8xx : public IOService
{
  OSDeclareDefaultStructors(Bt8xx);

  friend class Bt8xxUserClient;
  friend class Bt8xxImpl;
  
public:
  
  virtual Bt8xxImpl * instance();
  
  virtual bool init( OSDictionary *dictionary = 0 );
  virtual void free(void);
  
  virtual bool attach( IOService *provider );
  virtual void detach( IOService *provider );
  
  virtual IOService * probe( IOService * provider, SInt32 *score );
  
  virtual bool start( IOService *provider );
  virtual void stop ( IOService *provider );
  
  virtual IOReturn newUserClient( task_t owningTask, void * security_id, UInt32 type, IOUserClient ** handler );
  virtual void close( void );
  
  //virtual IOReturn setPowerState( UInt32 powerStateOrdinal, IOService * policyMaker);
  //virtual IOReturn registerWithPolicyMaker( IOService * policyMaker );

  static  void interruptOccurred( OSObject * object, IOInterruptEventSource * src, int count );
   
#if 0

  virtual WorkLoop * getWorkLoop(void);

#endif


#if HAVE_HAVE_PM
    // Simple power managment support:

    virtual IOReturn setPowerState( UInt32 powerStateOrdinal, IOService * whatDevice );

    virtual IOReturn registerWithPolicyMaker(IOService * policyMaker);
#endif

private:

  Bt8xxImpl       * mImpl;

#if HAVE_HAVE_PM
  unsigned long     mCurrentPowerState;
#endif  
};

