/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <AppKit/AppKit.h>
#import <IO/Manager/IOManager.hpp>
#import <util/Loader.h>

#import "PreferencesController.h"

static int           gArgc = 0;
static const char ** gArgv = 0;

extern "C" void EnterMovies();

NSEvent * nextEvent()
{
    NSString * mode = NSDefaultRunLoopMode; 

    NSTimeInterval seconds = 1;

    NSDate * until = [ NSDate dateWithTimeIntervalSinceNow:seconds];

    NSEvent * event = 
            
        [[ NSApplication sharedApplication ] nextEventMatchingMask: NSAnyEventMask untilDate:until inMode:mode dequeue:YES ];

    [ until   release ];
        

    return event;
}

void eventLoop()
{
    while( true ) {

        NSEvent * event = (NSEvent*) nextEvent();
    
        if( event ) {
#if 0
            printf("event(%d)\n", [event type ] );
            
            if( [event type ] == NSScrollWheel ) {
                //printf( "ScrollWheel event dx(%f) dy(%f) dz(%f)\n", [ event deltaX ], [ event deltaY ], [ event deltaZ ] );
            }
#endif            
            [ NSApp sendEvent: event ];
     
            [ event release ];
        }
            
        //idle();
    }
}


@interface MyDelegate : NSObject
{
}

- (void) applicationWillFinishLaunching: (NSNotification *) notification;
- (void) applicationDidFinishLaunching:  (NSNotification *) notification;
- (void) applicationWillTerminate:(NSNotification *)aNotification;

@end

@implementation MyDelegate


- (id) init
{
    [ super init ];
    
    return self;
}

- (void) applicationWillFinishLaunching: (NSNotification *) notification
{
}

extern "C" int initControllerPlugin( int argc, const char ** argv  );

- (void) applicationDidFinishLaunching: (NSNotification *) notification
{
    EnterMovies();

    // loadPlugin("ControllerPlugin", gArgc, gArgv );

    initControllerPlugin(gArgc, gArgv);
    
    IOManager::instance().start();
    
    eventLoop();
}

- (void) applicationWillTerminate:(NSNotification *)aNotification
{
}

- (IBAction) onQuit:(id)sender
{
    IOManager::instance().sendCommand( "WindowController", "onQuit" );
}

- (IBAction) onPreferences:(id)sender
{
    [PreferencesController show];
    
}

@end


int main(int argc, const char **argv, const char ** env )
{
    gArgc = argc;
    gArgv = argv;

#if 1
    NSAutoreleasePool * pool =[ [ NSAutoreleasePool alloc ] init ];

    [ [ NSApplication sharedApplication ] retain ];
    
    MyDelegate * myDelegate = [ MyDelegate new ];
    
    [ myDelegate retain ];

    [NSApp setDelegate: myDelegate ];

    [ pool release ];
#endif

    NSApplicationMain( argc, argv );

    return 0;
}
