#include <Cocoa/Cocoa.h>
#include <app/PreferencesController.h>

@interface MyDelegate : NSObject
{
    int visible;
}

- (void) applicationWillFinishLaunching: (NSNotification *) notification;
- (void) applicationDidFinishLaunching:  (NSNotification *) notification;
- (void) applicationWillTerminate:(NSNotification *)aNotification;
- (void)windowWillClose:(NSNotification *)aNotification;

@end

@implementation MyDelegate

- (id) init
{
    visible = false;
    
    [ super init ];
    
    return self;
}

- (void) applicationWillFinishLaunching: (NSNotification *) notification
{
}

- (void) applicationDidFinishLaunching: (NSNotification *) notification
{
    NSImage * img = [[NSImage alloc] initWithContentsOfFile:[[[NSBundle mainBundle] resourcePath] stringByAppendingString:@"/XTV.icns"]];

    if( img ) {
        puts("found image");
        [ NSApp setApplicationIconImage:img ];
    }
    
    [ PreferencesController show ];

    visible = true;
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
    return NO;
}

- (void)windowWillClose:(NSNotification *)aNotification
{
    puts( "PreferencesController.windowWillClose" );
    
}

@end

int main(int argc, const char *argv[])
{    
#if 0
    MyDelegate * myDelegate = [ MyDelegate new ];
    
    [ myDelegate retain ];
 
    [NSApp setDelegate: myDelegate ];
#endif    
    NSApplicationMain( argc, argv );
        
    return 0;
}
