/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <Foundation/Foundation.h>
#import <AppKit/NSWindowController.h>
#import <AppKit/NSSlider.h>
#import <AppKit/NSPopUpButton.h>

@interface PreferencesController : NSObject {

    IBOutlet NSPopUpButton   * mCard;
    IBOutlet NSPopUpButton   * mTuner;
    IBOutlet NSPopUpButton   * mFormat;
    IBOutlet NSPopUpButton   * mCompression;
    IBOutlet NSPopUpButton   * mVideoSource;
    IBOutlet NSPopUpButton   * mAudioSource;
    IBOutlet NSPopUpButton   * mAudioOutput;
    IBOutlet NSPopUpButton   * mAudioInput;
    IBOutlet NSPopUpButton   * mCountry;
    IBOutlet NSButton        * mStayOnTop;
    IBOutlet NSSlider        * mVolume;
    IBOutlet NSSlider        * mBalance;
    IBOutlet NSSlider        * mHue;
    IBOutlet NSSlider        * mSaturationU;
    IBOutlet NSSlider        * mSaturationV;
    IBOutlet NSSlider        * mContrast;
    IBOutlet NSSlider        * mBrightness;
    IBOutlet NSSlider        * mRecordingScale;
    IBOutlet NSTextField     * mRecordingPrefix;
    IBOutlet NSTextField     * mRecordingDir;
    IBOutlet NSButton        * mRecordVideo;
    IBOutlet NSButton        * mRecordAudio;
    IBOutlet NSSlider        * mFrameRate;
    IBOutlet NSQuickDrawView * mVideoView;
    IBOutlet NSWindow	    * mWindow;
    // mod philipp here
    IBOutlet NSPopUpButton  * mOpenGL;
    
    BOOL              mInited;
}

+(void) show;

-(id) init;

- (IBAction) onDefault:(id)sender;

- (IBAction) onCardChange:(id)sender;
- (IBAction) onCountryChange:(id)sender;
- (IBAction) onTunerChange:(id)sender;
- (IBAction) onFormatChange:(id)sender;
- (IBAction) onHueChange:(id)sender;
- (IBAction) onSaturationChangeV:(id)sender;
- (IBAction) onSaturationChangeU:(id)sender;
- (IBAction) onContrastChange:(id)sender;
- (IBAction) onBrightnessChange:(id)sender;
- (IBAction) onAudioSourceChange:(id)sender;
- (IBAction) onVideoSourceChange:(id)sender;
- (IBAction) onVolumeChange:(id)sender;
- (IBAction) onBalanceChange:(id)sender;
- (IBAction) onAudioOutputChange:(id)sender;
- (IBAction) onAudioInputChange:(id)sender;
- (IBAction) onSetRecordingPrefix:(id)sender;
- (IBAction) onSetRecordingDirNav:(id)sender;
- (IBAction) onSetRecordingDirEdit:(id)sender;
- (IBAction) onRecordAudioChange:(id)sender;
- (IBAction) onRecordVideoChange:(id)sender;
- (IBAction) onFrameRateChange:(id)sender;
- (IBAction) onCompressionChange:(id)sender;
- (IBAction) onStayOnTopChange:(id)sender;
// mod philipp here
- (IBAction) onOpenGL:(id)sender;

- (IBAction) hideWindow:(id)sender;

- (NSQuickDrawView*) qdView;

-(void) beforeFirstShow;

@end
