#!/bin/sh

#
# Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


set -x

rm -f /tmp/loadkext.log
touch /tmp/loadkext.log

function warn()
{
	date=`date "+%Y:%m:%d"`

	echo $date:WARINING: $* >> /tmp/loadkext.log
}

function log()
{
	date=`date "+%Y:%m:%d"`

	echo $date:LOG: $* >> /tmp/loadkext.log
}

function err()
{
	date=`date "+%Y:%m:%d"`

	echo $date:ERROR: $* >> /tmp/loadkext.log
}

log $0: $* 

############### initialisation of globals

APPDIR=$1

drv=Bt8xx
kext=$drv.kext

############## parameter testing

if [ x"$APPDIR" = x"" ]
then
        err $0: need applications directory as pararmeter 1
        exit 1
fi


############## load driver

/sbin/kextload $APPDIR/$kext

success=`/usr/sbin/kmodstat | grep org.gnu.iokit.Bt8xx`

log "success =\"$success\""

if [ x"" = x"$success" ]
then
    err "Failed load kernel extension"
    exit 2
else
    log "Loaded kernel extension"
fi

exit 0






