/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ListComonents.h"
#include <Carbon/Carbon.h>
#include <QuickTime/QuickTime.h>

int main()
{
    ComponentDescription cd;
    Component            c   = 0;

    cd.componentType         = 0;
    cd.componentSubType      = 0;
    cd.componentManufacturer = 0;
    cd.componentFlags        = 0;
    cd.componentFlagsMask    = 0;

    while(( c = FindNextComponent( c, &cd )) != 0 ) {
        
        ComponentInstance ci;
                
        if( OpenAComponent( c, &ci ) == noErr ) {
                
            Handle componentName = NewHandle(0);
            Handle componentInfo = NewHandle(0);

            char buf1[256];
            char buf2[256];
        
            ComponentDescription cd1;

            printf("c = %p\n", c );
        
            memset( &cd1, 0, sizeof(cd1 ));
            
            if( GetComponentInfo( (Component) ci, &cd1, componentName, componentInfo, nil ) == noErr ) {
                printf( "Component(%s) Info(%s)\n", PToCStr( (const StringPtr ) *componentName, buf1 ), 
                        PToCStr( (const StringPtr ) *componentInfo, buf2 ));
            }
        
            DisposeHandle(componentName);
            DisposeHandle(componentInfo);
            
            CloseComponent(ci);
        }
    }
    return 0;
}
