/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Carbon/Carbon.h>
#include <IO/osx/TVHardware.hpp>
#include <IO/Manager/IOOutput.hpp>
#include <IO/Manager/IOInput.hpp>
#include <IO/Manager/IOBuffer.hpp>
#include <assert.h>

#import <lib/bt848.h>
#import <lib/Bt8xxLib.h>
#import <lib/bt848.h>
#import <lib/i2c.h>
#import <lib/Tuner.h>
#import <lib/Audio.h>

extern "C" int Audio_SetSource(AUDIOMUXTYPE nChannel);
extern long AudioSource;
static long lastSelection = 0;

static TVHardware * theTVHardware = 0;

/* static */ TVHardware& TVHardware::instance()
{
    if( theTVHardware == 0 )
        theTVHardware = new TVHardware();
        
    assert( theTVHardware != 0 );
    
    return *theTVHardware;
}

   
TVHardware::TVHardware()
 : IOHardware( "TVHardware")
{
}
        
TVHardware::~TVHardware()
{
    
}

void TVHardware::updateDeviceList()
{
    IODescription dd("AudioDevice");

    dd.setName( "Bt8xx Video" );

    dd.setDeviceID( 0 );
    dd.setDirection( IODescription::ioIn );
    
    mDeviceList.append( new IODescription(dd) );

    dd.setName( "Bt8xx Audio" );

    dd.setDeviceID( 1 );
    dd.setDirection( IODescription::ioIn );

    mDeviceList.append( new IODescription(dd) );

    dd.setName( "Bt8xx TeleText" );

    dd.setDeviceID( 2 );
    dd.setDirection( IODescription::ioIn );

    mDeviceList.append( new IODescription(dd) );
}

/* static */ bool TVHardware::init( IODescription::IODirection direction, IODeviceID id, void * _device )
{ 
    return ( BT848_Init() == KERN_SUCCESS );
}

/* static */ bool TVHardware::finit( IODescription::IODirection direction, IODeviceID anID )
{
    Audio_SetSource(AUDIOMUX_MUTE);

    return true;
}

/* static */ bool TVHardware::start( IODescription::IODirection direction, IODeviceID anID, IONode * _device )
{
    if( anID == 0 ) {
        Start_Capture();
    }
    else {
        ; //Audio_SetSource( (AUDIOMUXTYPE) lastSelection );
    }
    
    return true;
}

/* static */ bool TVHardware::stop ( IODescription::IODirection direction, IODeviceID anID, IONode * _device )
{
    lastSelection = AudioSource;
    
    if( anID == 0 ) {

        Stop_Capture();
    }
    else {
        ; //Audio_SetSource( AUDIOMUX_MUTE );
    }
    
    return true;
}

extern "C" int initIOModules()
{
    return 0;
}
