/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_AUDIO_HARDWARE_HPP
#define _XTV_AUDIO_HARDWARE_HPP

#include <IO/Manager/IOHardware.hpp>

class AudioHardware : public IOHardware {

    public:

        static AudioHardware& instance();

        static bool start( IODescription::IODirection direction, IODeviceID anID, IONode * _device );
        static bool stop ( IODescription::IODirection direction, IODeviceID anID, IONode * _device );
    
        static bool AudioHardware::finit( IODescription::IODirection direction, IODeviceID id );

        static bool AudioHardware::init ( IODescription::IODirection direction, IODeviceID id, 
                                          size_t bufferSize, int nChannels, void * _device );

        static  bool setVolume( IODeviceID anID, int   l, int   r, bool isInput  );
        static  bool getVolume( IODeviceID anID, int & l, int & r, bool isInput  );

        static  int  SetHWPlayThru (IODeviceID deviceInfo, int channel, short hwPlayThruOn);

    protected:
    
        AudioHardware();
        
        virtual ~AudioHardware();
        
        
    private:
    
        virtual void updateDeviceList();

};

#endif // _XTV_AUDIO_HARDWARE_HPP