/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_OUTPUT_VIDEO_OUTPUT_WINDOW_HPP
#define _XTV_IO_OUTPUT_VIDEO_OUTPUT_WINDOW_HPP

/*
 *  Audio.h
 *  xtv
 *
 *  Created by andi on Wed Oct 10 2001.
 *
 */

#include <IO/Manager/IOOutput.hpp>
#include <IO/Manager/IOModel.hpp>
#include <IO/Manager/IOView.hpp>

@class MyGLWindow;

class OutputWindow : public IOOutput, public IOView {

    public:

        OutputWindow( const string & aName, IODeviceID anID );
    
        virtual ~OutputWindow();
    
        virtual bool start();
        virtual bool stop();

        virtual bool pause();
        virtual bool resume();
    
        virtual size_t frameSize();

        virtual bool updateFrom( IOBuffer * ioBuf );

        virtual bool command( const string & command, 
                              const string & param1 = "", const string & param2 = "", 
                              const string & param3 = "", const string & param4 = "" );

        string getValue( const string & valueName );
        
        void updateFrom( IOModel * );
        
    protected:

        void init();
        void finit();
    
        void createWindow();

        MyGLWindow * mWindow;
        
        IOModel       mTVType;
        IOModel       mChannel;
        IOModel       mMovieFile;
        IOModel       mStayOnTop;
};

#endif // _XTV_IO_OUTPUT_VIDEO_OUTPUT_WINDOW_HPP