/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_VIDEO_GLWINDOW_H
#define _XTV_VIDEO_GLWINDOW_H

#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <OpenGL/glu.h>
#import <OpenGL/glext.h>
#import <OpenGL/CGLRenderers.h>

#import <Appkit/Appkit.h>

@class GLView;

@interface GLWindow : NSWindow {

@private

        // User Defined Variables
        float	angle;		// Used For Rotation

        void                  * nsglFormat;
        GLUquadricObj         * quadratic; // Storage For Our Quadratic Objects

        // GL texturing

        GLubyte *  gpTexture; // texture storage (used on for set up when direct texturing
        short      gUsedTextureHeight, gUsedTextureWidth;
        float      gfTextureScale;
        short      gvTextureOffset, gvTextureEnd, ghTextureOffset, ghTextureEnd;

        // Movie
        NSRect     gMovieRect;
        short      gMovieWidth, gMovieHeight;

        // GL stuff
    
        int           gfHasPackedPixels;
        NSRect        grectWin;
        GLuint        gFontList;
        unsigned long gRowStride;

        struct structMovieSettings {
            short  wWindowWidth, wWindowHeight; // initial window size
            short  wTextureSize; 		// texture size
            short  wOffScreenDepth; 		// offscreen depth
            int    fFullScreen; 		// full screen
            int    fDirectTexturing; 	// direct texture
            int    fVBLSync;
        };
        
        struct structMovieSettings gMovieSettings;

        bool mNeedUpdate;
        int mNewWidth, mNewHeight;
        bool mDrawInfo;
        
        void * myGLView;

        int mTopBorder, mRightBorder, mLeftBorder, mBottomBorder;

        NSView * mainView;
        GLView * glView;

        bool     mFullScreen;
        NSRect   mSavedBounds;
        int      mSavedLevel;
}

+ (id) alloc;

- (id)initWithContentRect:(NSRect)contentRect styleMask:(unsigned int)styleMask backing:(NSBackingStoreType)backingType defer:(BOOL)flag;

- (void) display;

- (void) move:(float) x y:(float) y;
- (void) resize:(float) w h:(float) h;
                
- (void) draw:( const unsigned char *) buffer;

- (int) setupGL:(NSRect) windowPos movieSize:(NSSize) movieSize;

- (void) sizeChanged:(float) width height:(float) height;
- (void) posChanged:(float) x y:(float) y;

-(bool) create:(NSRect) windowPos;

- (NSSize) windowWillResize:(NSWindow *)sender toSize:(NSSize)proposedFrameSize;
        
- (void) toggleInfo;
- (BOOL) acceptsFirstResponder;
- (BOOL) canBecomeMainWindow;
- (BOOL) canBecomeKeyWindow;

-(int) getRightBorder;
-(int) getLeftBorder;

- (void) setRightBorder:( int ) val;
- (void) setLeftBorder:( int ) val;

-(int) getTopBorder;
-(int) getBottomBorder;

- (void) setTopBorder:( int ) val;
- (void) setBottomBorder:( int ) val;
    
- (void) updateGLMovieForGrow:(short) width height:(short) height;

- (void) initGL:(short) width height:(short) height;

- (void) setFrustum:(short) width height:(short) height focalLen:(float) focalLen minDepth:(float) minDepth maxDepth:(float) maxDepth;

- (void) initMembers;

- (void) updateContent;
- (void) updateGLView;

- (BOOL) isFullScreen;

- (void) toggleFullScreen;

- (GLView*) glView;

- (void) handleDrop:(NSString*) fileName;

@end // interface GLWindow

#endif //_XTV_VIDEO_GLWINDOW_H