/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Output/Video/GLView.h>
#include <AppKit/AppKit.h>

@implementation GLView

- (BOOL) isOpaque
{
    return YES;
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
    return YES;
}

- (BOOL) acceptsFirstResponder
{
    return YES;
}

-(void)drawRect:(NSRect)rect
{
#if 0
    [ super drawRect:rect ];
    
    [[NSColor blackColor] set];
    
    NSRectFill( [ self frame ] );
#endif
}
// mod philipp here
- (id)initWithFrame:(NSRect) frameRect RendererSelection:(UInt32) RendererSelection
{
    // Basic pixel format with some default values
    NSOpenGLPixelFormatAttribute attr[] = 
    {
        NSOpenGLPFANoRecovery,
        NSOpenGLPFADoubleBuffer,
	NSOpenGLPFAAccelerated,
        NSOpenGLPFARendererID, RendererSelection, // mod philipp here
	NSOpenGLPFAColorSize, (NSOpenGLPixelFormatAttribute) bitsPerPixel,
	NSOpenGLPFADepthSize, (NSOpenGLPixelFormatAttribute) depthSize,
        (NSOpenGLPixelFormatAttribute) 0 
    };

    //puts("MyGLView.initWithFrame");

    bitsPerPixel = depthSize = 16;
    // Create our pixel format
    nsglFormat = [[NSOpenGLPixelFormat alloc] initWithAttributes:attr];

    // If the format isn't valid...
    if(!nsglFormat)
	NSLog(@"Pixel format is nil");
    // Otherwise create the context...

    self =  [super initWithFrame:frameRect pixelFormat:nsglFormat];
    // If we don't get a context...

    if(!self)
	NSLog(@"initWithFrame failed");

    // Otherwise, make the context current and continue
    [[self openGLContext] makeCurrentContext];
    
    return self;
}

- (void) keyDown:(NSEvent *)theEvent;
{
    [ super keyDown:theEvent ];    
}

- (void) keyUp:(NSEvent *)theEvent;
{
    [ super keyUp:theEvent ];
}

- (void) mouseDown:(NSEvent *)theEvent;
{    
    [ super mouseDown:theEvent ];
}

- (void) mouseUp:(NSEvent *)theEvent;
{
    [ super mouseUp:theEvent ];
}

- (void) mouseMoved:(NSEvent *)theEvent
{
    NSPoint at = [ theEvent locationInWindow ];

    //buddy->mouseMove( at.x, at.y, [ theEvent buttonNumber ], [ theEvent modifierFlags ] );
}

@end // @implementation MyGLView
