/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_VIDEO_GLVIEW_H
#define _XTV_VIDEO_GLVIEW_H

#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <OpenGL/glu.h>
#import <OpenGL/glext.h>
#import <OpenGL/CGLRenderers.h>

#import <Appkit/Appkit.h>

@interface GLView : NSOpenGLView
{
    NSOpenGLPixelFormatAttribute	pfAttribs[32];
    NSOpenGLPixelFormat			*nsglFormat;
    NSOpenGLContext			*glContext;

    unsigned long			bitsPerPixel, depthSize;
}

// Overrides
// mod philipp here
- (id)initWithFrame:(NSRect) frameRect RendererSelection:(UInt32) RendererSelection;

- (void) keyDown:(NSEvent *)theEvent;
- (void) keyUp:(NSEvent *)theEvent;
- (void) mouseDown:(NSEvent *)theEvent;
- (void) mouseUp:(NSEvent *)theEvent;
- (void) mouseMoved:(NSEvent *)theEvent;
- (BOOL) acceptsFirstMouse:(NSEvent *)theEvent;
- (BOOL) acceptsFirstResponder;
- (BOOL) isOpaque;

@end // _XTV_VIDEO_GLVIEW_H

#endif //_XTV_VIDEO_GLVIEW_H