/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_TELE_TEXT_OUTPUT_HPP
#define _XTV_TELE_TEXT_OUTPUT_HPP

#include <IO/Manager/IOOutput.hpp>
#include <IO/Manager/IOThread.hpp>
#include <IO/Input/TeleTextInput.hpp>
#import <list>
#import <lib/aletv_vbi.h>

/* forward */ class VTWindow;

class TeleTextOutput : public IOOutput {

    public:

        TeleTextOutput( const string & aName, IODeviceID anID );
    
        virtual ~TeleTextOutput();
    
        virtual bool start();
        virtual bool stop();
    
        virtual size_t frameSize();
    
        virtual bool updateFrom( IOBuffer * ioBuf );
        
    protected:

        void init();
        void finit();
    
        void run();

        IOThread   mWorkThread;
        VTWindow * mWindow;
        
        friend void * teleTextOutputThreadEntry( void * _this );
                
        typedef list<TeleTextInput::VTPage*> PageList;
        
        TeleTextInput::VTPage * findPage( int channel, int pageNo, int subPageNo );
        void                    addPage( TeleTextInput::VTPage * );
        
        PageList mPageList;

        virtual void showPage( int pageNo, int subNo );
        
        friend class VTWindow;
};

#endif // _XTV_TELE_TEXT_OUTPUT_HPP