/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_QT_RECORDER_HPP
#define _XTV_IO_QT_RECORDER_HPP

#include <IO/Manager/IOOutput.hpp>
#include <IO/Manager/IOThread.hpp>

#include <Carbon/Carbon.h>
#include <QuickTime/QuickTime.h>

/* forward */ class VideoRecorder;
/* forward */ class AudioRecorder;

class QTRecorder : public IOOutput {

    typedef IOOutput super;

    public:

        QTRecorder( const string & aName, IODeviceID anID );
    
        virtual ~QTRecorder();
    
        virtual bool start();
        virtual bool stop();
    
        virtual bool updateFrom( IOBuffer * ioBuf );
    
        virtual size_t frameSize();
        virtual size_t videoFrameSize();
        virtual size_t audioFrameSize();

        virtual bool isRecording();
        
        virtual void toggleRecord();
        
        virtual bool command( const string & command, 
                              const string & param1 = "", const string & param2 = "", 
                              const string & param3 = "", const string & param4 = "" );

    protected:

        void init();
        void finit();
    
        bool CreateSoundTrack();
        bool CreateVideoTrack();

        void AddVideoSamplesToMedia( IOBuffer * ioBuf );
        void AddAudioSamplesToMedia( IOBuffer * ioBuf );
        
        bool BeginMovie();
        void EndMovie();

        IOThread   mWorkThread;
        time_t     mStartTime;
        size_t     mVideoFrames;
        size_t     mAudioFrames;
                
        Track                    mAudioTrack;
        Media                    mAudioMedia;
        Track                    mVideoTrack;
        Media                    mVideoMedia;
        Movie                    mQTMovie;
        short                    mResRefNum;
        Rect                     mTrackFrame;
        string                   mFileName;
        int                      mDivider;
        ImageDescriptionHandle   mImageDesc;
        SoundDescriptionV1Handle mSoundDesc;
        
        AudioRecorder        * mAudioRecorder;
        VideoRecorder        * mVideoRecorder;
        GWorldPtr              mGWorld;
        
        bool                   mGO;
        unsigned               mDroppedFrames;
        int                    mCodec;
        float                  mFrameRate;
        int                    mUseAudio;
        int                    mUseVideo;
        
        friend class AudioRecorder;
        friend class VideoRecorder;
};

#endif // _XTV_IO_QT_RECORDER_HPP