/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <IO/Misc/ProgramList.hpp>
#import <IO/Manager/IOManager.hpp>
#import <IO/Manager/IOLockGuard.hpp>
//#import <IO/Output/Video/GLWindow.h>
#import <skins/SkinBase.hpp>

#import <AppKit/AppKit.h>

#import <unistd.h>
#import <time.h>
#import <sys/time.h>

#import <lib/Preferences.h>

ProgramList::ProgramList( const string & aName )
 : IOObject( aName, "ProgramList" )
 , mCurrentProgram  ( "ProgramList.Current"  )
{
    init();
}

ProgramList::~ProgramList()
{    
    finit();
}


void ProgramList::createWindow()
{
}

void ProgramList::init()
{
    mWindow = 0;

    mCurrentProgram.addView( this );                

    for( int i = 0; i < MAX_PROGRAMS; i++ ) {
        
        char name[8];
        
        sprintf( name, "%d", i );
        
        int program = GetPrivateProfileInt( "ProgramList", name, -1 );
    
        mProgramMap[i] = program;
    }
}

void ProgramList::finit()
{
    IOManager::instance().unregisterObject( this );
}

void ProgramList::updateFrom( IOModel * aModel ) 
{

    printf("%s.updateFrom: %s = %s\n", getName().c_str(), aModel->getName().c_str(),  aModel->getString().c_str() );
        
    if( aModel->getName() == "ProgramList.Current" ) {

        int program = atoi( aModel->getString().c_str() );
        
        if( program >= 0 && program < MAX_PROGRAMS ) {
        
            if( mProgramMap[program] != -1 ) {

                char programStr[8];
            
                sprintf( programStr, "%d", mProgramMap[program] );
            
                IOManager::instance().sendCommand( "Tuner", "setChannel", programStr );
            }
        }
    }
}

string  ProgramList::getValue( const string & valueName )
{
    char buffer[256];
    
    sprintf( buffer, "-1" );
    
    if( valueName == "current" ) {
        sprintf( buffer, "%d", mCurrentProgram.getInt() );
    }
 
    return buffer;
 }

bool ProgramList::command( const string & command, 
                        const string & param1,  const string & param2, const string & param3, const string & param4 )
{
    printf("ProgramList::command(%s,%s,%s,%s,%s)\n", command.c_str(), param1.c_str(), param2.c_str(), param3.c_str(), param4.c_str() );
    
    if( command == "store" ) {

        char name[8];

        sprintf( name, "%d", mCurrentProgram.getInt() );

        WritePrivateProfileString( "ProgramList", name, param1.c_str() );
        
    }
    else if( command == "select" ) {
    
        int program = atoi( param1.c_str() );
        
        if( program >= 0 && program < MAX_PROGRAMS ) {
            mCurrentProgram.setValue( program );
        }
        
    }
    else if( command == "current" ) {
        mCurrentProgram.setValue( mCurrentProgram.getInt() );
    }
    else if( command == "first" ) {
        mCurrentProgram.setValue( 0 );
    }
    else if( command == "last" ) {
        mCurrentProgram.setValue( MAX_PROGRAMS-1 );
    }
    else if( command == "previous" ) {
    
        if(  mCurrentProgram.getInt() > 0 ) {
            mCurrentProgram.setValue( mCurrentProgram.getInt() - 1 );
        }
    }
    else if( command == "next" ) {
        if(  mCurrentProgram.getInt() < MAX_PROGRAMS - 1  ) {
            mCurrentProgram.setValue( mCurrentProgram.getInt() + 1 );
        }
    }

    return true;
}

extern "C" int initProgramListPlugin( int argc, const char ** argv )
{
    ProgramList * pl = new ProgramList( "ProgramList" );
    
    IOManager::instance().registerObject( pl );
    
    return true;
}
