/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_VIEW_HPP
#define _XTV_IO_VIEW_HPP

#include <list>

using namespace std;

/* forward */ class IOModel;

class IOView {

    // not derived from IOObject due to multiple inheritance in derived classes ( IOObject )
    
public:

    IOView();
    
    virtual ~IOView();
    
    virtual void updateFrom( IOModel * ) = 0;
    
    virtual void addModel( IOModel * );
    virtual void remModel( IOModel * );

private:

    IOModel * findModel( IOModel * aModel );

    void init();
    void finit();
    
    list<IOModel*> mSubjects;
    
};
#endif // _XTV_IO_VIEW_HPP