/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IOView.hpp>
#include <IO/Manager/IOModel.hpp>


IOView::IOView()
{
}
    
IOView::~IOView()
{
}

IOModel * IOView::findModel( IOModel * aModel )
{
    list<IOModel*>::iterator iter( mSubjects.begin() );
    
    while( iter != mSubjects.end() ) {
    
        IOModel * m = *iter;
        
        if( m == aModel ) {
            return m;
        }
        iter++;
    }
    return 0;
}

void IOView::addModel( IOModel * aModel )
{
    if( ! findModel( aModel )) {
        mSubjects.push_back( aModel );
    }
}

void IOView::remModel( IOModel * aModel )
{
    if(  findModel( aModel )) {
        mSubjects.remove( aModel );
    }
}

void IOView::init()
{
}

void IOView::finit()
{
    list<IOModel*>::iterator iter( mSubjects.begin() );
    
    while( iter != mSubjects.end() ) {
    
        IOModel * m = *iter;
        
        m->remView( this );
        
        iter++;
    }

    while( mSubjects.size() != 0 ) {
    
        mSubjects.pop_front();
    }
}
