/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_THREAD_HPP
#define _XTV_IO_THREAD_HPP

/*
 *  Audio.h
 *  xtv
 *
 *  Created by andi on Wed Oct 10 2001.
 *
 */

#include <IO/Manager/IOObject.hpp>

class IOThread : public IOObject {

    public:

        typedef enum Request { ioNullRequest = 0, ioStop, ioPause };
        typedef enum State   { ioNullState   = 0, ioCreated = 1, ioPaused, ioRunning, ioStopped };
        
        IOThread( const string & aName, bool useRT = false );
    
        virtual ~IOThread();
    
        virtual bool start( void *(*start_routine)(void *), void *arg );
        virtual bool stop();
        virtual bool pause();
        virtual bool resume();
        
        virtual bool isRunning();
        virtual bool isPaused();

        virtual void threadStartRoutine();

        virtual Request serviceCancellation();
        
    private:

        void init();
        void finit();
    
        State      mState;
        Request    mRequest;
        pthread_t  mWorkThread;
        bool       mUseRT;
        
        void *(*mEntry)(void *);
        void *  mArg;
};

#endif // _XTV_IO_THREAD_HPP