/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_STREAM_HPP
#define _XTV_IO_STREAM_HPP

#include <IO/Manager/IOObject.hpp>
#include <list>

/*
    description:
    
    IOStream:
    
*/

/* forward */ class IOInput;
/* forward */ class IOOutput;
/* forward */ class IOBuffer;

class IOStream : public IOObject
{

    public:
           
        static IOStream * create( const string & name );

        virtual bool isStarted();
        
        virtual bool start();
        virtual bool stop();
                
        virtual bool push( IOBuffer * );
        
        typedef list<IOOutput*> ConsumerList;
        typedef list<IOInput *> ProducerList;

        virtual void stopProducers();
        
    protected:
    
        IOStream( const string & aName );
        virtual ~IOStream();

        virtual bool addProducer( IOInput * );
        virtual bool remProducer( IOInput * );

        virtual bool addConsumer( IOOutput * );
        virtual bool remConsumer( IOOutput * );

    private:

        
    
	string mName;
        
        ConsumerList    mConsumers;
        ProducerList    mProducers;
        bool            mStarted;
         
        void init();       
        void finit();       

        friend class IOInput;	// to access add/rem Consumer/Producer
        friend class IOOutput;	// to access add/rem Consumer/Producer
};

#endif // _XTV_IO_NODE_HPP