/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IOStream.hpp>
#include <IO/Manager/IOInput.hpp>
#include <IO/Manager/IOOutput.hpp>
#include <IO/Manager/IOBuffer.hpp>

IOStream::IOStream( const string & aName )
    : IOObject( aName, "IOStream" )
{

}

void IOStream::init()
{
    mStarted = false;
}

void IOStream::finit()
{
}

IOStream::~IOStream()
{
}

bool IOStream::isStarted()
{
    lock();
    
    bool result = mStarted;
    
    unlock();
    
    return result;
}
      
/* static */ IOStream * IOStream::create( const string & aName ) 
{
    IOStream * result = new IOStream( aName );
    
    return result;
}

bool IOStream::push( IOBuffer * ioBuf )
{
    bool delivered = false;
    
    if( mStarted ) {

        ConsumerList::iterator iter = mConsumers.begin();
        
        while( iter != mConsumers.end() ) {
        
            IOOutput * out = *iter;
            
            if( out->isStarted()  && out->updateFrom( ioBuf ) ) {
                //printf( "delivred %s to %s\n", ioBuf->getName().c_str(), out->getName().c_str()  );
                delivered = true;
            }
            
            iter++;
        }
        
    }
    
    return delivered;
}

bool IOStream::start()
{
    if( mProducers.size() > 0  && mConsumers.size() > 0 ) {
        
        bool consumerStarted = false;
        bool producerStarted = false;
        
        ConsumerList::iterator iter = mConsumers.begin();
        
        while( iter != mConsumers.end() ) {
        
            IONode * n = *iter;
            
            if( n->start() ) {
                consumerStarted = true;
            }
            else {
                printf( "failed to start %s\n", n->getName().c_str());
            }
            
            iter++;
        }
        
        if( consumerStarted ) {
        
            ProducerList::iterator iter = mProducers.begin();
            
            while( iter != mProducers.end() ) {
        
                IONode * n = *iter;
            
                if( n->start() ) {
                    producerStarted = true;
                }
                else {
                    printf( "failed to start %s\n", n->getName().c_str());
                }
            
                iter++;
            }
        }
        else {
            // raise error
        }
        
        mStarted = ( producerStarted == true && consumerStarted == true );
    }
    return mStarted;
}

bool IOStream::stop()
{
    if( mStarted ) {
        
        ProducerList::iterator iter = mProducers.begin();
        
        while( iter != mProducers.end() ) {
        
            IONode * n = *iter;
            
            if( ! n->stop() ) {
                printf("couldn't stop %s\n", n->getName().c_str() );
            }
            
            iter++;
        }
        
        ConsumerList::iterator iter2 = mConsumers.begin();
        
        while( iter2 != mConsumers.end() ) {
        
            IONode * n = *iter2;
            
            if( ! n->stop() ) {
                printf("couldn't stop %s\n", n->getName().c_str() );
            }
            
            iter2++;
        }
        
        mStarted = false;
    }

    return mStarted == false;

}

bool IOStream::addProducer( IOInput * node )
{
    if( node ) {
    
        node->retain();
    
        mProducers.push_back( node );
    }
    
    return node != 0;
}

bool IOStream::remProducer( IOInput * node )
{
    if( node ) {

        mProducers.remove( node );
    
        node->release();
    }

    return node != 0;
}

bool IOStream::addConsumer( IOOutput * node )
{
    if( node ) {
    
        node->retain();
    
        mConsumers.push_back( node );

    }
    
    return node != 0;
}

bool IOStream::remConsumer( IOOutput * node )
{
    if( node ) {
        
        mConsumers.remove( node );
    
        node->release();
    }

    return node != 0;
}

void IOStream::stopProducers()
{
    ProducerList::iterator iter = mProducers.begin();
        
    while( iter != mProducers.end() ) {
        
        IONode * n = *iter;
            
        n->stop();
    
        iter++;
    }
}