/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IOOutput.hpp>
#include <IO/Manager/IOStream.hpp>

IOOutput::IOOutput( const string & aName, IODeviceID anID )
 : IONode( aName, anID )
{
    setType("IOOutput");
    
    init();
}

IOOutput::~IOOutput()
{
    finit();
}

bool IOOutput::updateFrom( IOBuffer * ioBuf )
{
    mBuffers->pushBack( ioBuf );
    
    return true;
}
    
size_t IOOutput::bufferCount()
{
    if( mBuffers )
        return mBuffers->size();

    return 0;
}

IOBuffer * IOOutput::getBuffer(int millisec )
{
    return mBuffers->popFront( millisec );
}

bool IOOutput::attachTo( IOStream * s, bool shouldStart  )
{    
    if( mStream ) {
        mStream->remConsumer( this );
    }

    mStream = 0;
    
    if( s->addConsumer( this ) ) {

        mStream = s;

       if( shouldStart && s->isStarted() ) {
        
            start();
        }
    }
 
       return mStream != 0;
}

bool IOOutput::detachFromStream()
{
    if( isStarted() ) {
        stop();
    }

    if( mStream && mStream->remConsumer( this ) ) {
        mStream = 0;
    }
    return mStream == 0;
}

void IOOutput::init()
{
    mBuffers = IOBufferList::create();
}

void IOOutput::finit()
{
    if( mBuffers )
        mBuffers->release();
}

