/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_OBJECT_HPP
#define _XTV_IO_OBJECT_HPP

#include <string>

/*
    description:
    
    IONode:
    
*/

using namespace std;

/* forward */ class IOObjectPrivate;

class IOObject
{

    public:
        
        const string & getName() const;
        const string & getType() const;
        
        void setName( const string & );
        void setType( const string & );
        
        virtual void retain();
        virtual void release();

        virtual void lock();
        virtual void unlock();

        virtual void wait( int milisecs = -1 );
        virtual void signal();

        virtual bool isA( const string & aType ) const;
         
        virtual int useCount();

        virtual bool command( const string & command, 
                              const string & param1 = "", const string & param2 = "", 
                              const string & param3 = "", const string & param4 = "" );
 
        virtual string getValue( const string & valueName );
               
    protected:

        IOObject( const string   & aName,  const string   & aType );
        virtual ~IOObject();

    private:

        IOObject( const IOObject &  );
    
        IOObjectPrivate * mPrivate;
        unsigned          mMagic;
        
};

#endif // _XTV_IO_OBJECT_HPP