/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_NODE_HPP
#define _XTV_IO_NODE_HPP

#include <IO/Manager/IOObject.hpp>

/*
    description:
    
    IONode:
    
*/

/* forward */ class IOStream;

typedef unsigned int  IODeviceID;

class IONode : public IOObject
{

    typedef IOObject super;
    
    public:

        virtual void release();
                    
        virtual bool attachTo  ( IOStream *,  bool start = true  ) = 0;
        virtual bool detachFromStream()       = 0;
        
        virtual bool start() = 0;
        virtual bool  stop() = 0;

        virtual bool isInited();
        virtual bool isStarted();
        virtual bool isAttached();
                
        IODeviceID getDeviceID() const;
        
        virtual string streamName();
        
        virtual IOStream * attachedTo();

    protected:
    
        IONode( const string & aName, IODeviceID anID );
        virtual ~IONode();

    protected:
    
	string          mName;
        bool            mStarted;        
        bool            mInited;
    
        IODeviceID      mDeviceID;
        IOStream      * mStream;
        
        void init();
        void finit();
};

#endif // _XTV_IO_NODE_HPP