/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IONode.hpp>
#include <IO/Manager/IOStream.hpp>
#include <IO/Manager/IOManager.hpp>

IONode::IONode( const string & aName, IODeviceID anID )
    : IOObject( aName, "IONode" ), mDeviceID( anID ) 
{
    init();
}

IONode::~IONode()
{
    finit();
}

IODeviceID IONode::getDeviceID() const
{
    return mDeviceID;
}

void IONode::release()
{
    if( isStarted() ) {
        stop();
    }
        
    super::release();
}

void IONode::init()
{
    mStarted = false;
    mInited  = false;
    mStream  = 0;
    
}

void IONode::finit()
{
    mStarted = false;
}

string IONode::streamName()
{
    if( attachedTo() ) {
        return attachedTo()->getName();
    }
    return string("");
}
        
IOStream * IONode::attachedTo() 
{ 
    return mStream;
}

bool IONode::isInited()
{
    lock();
    
    bool result = mInited;
    
    unlock();
    
    return result;
}

bool IONode::isStarted()
{
    lock();
    
    bool result = mStarted;
    
    unlock();
    
    return result;
}

bool IONode::isAttached()
{
    lock();
    
    bool result = (mStream != 0);
    
    unlock();
    
    return result;
}
