/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_MODEL_HPP
#define _XTV_IO_MODEL_HPP

#include <list>
#include <string>
#include <IO/Manager/IOObject.hpp>

/* forward */ class IOView;

class IOModel : public IOObject {

    string   mValue;
    void   * mMyDelegate;
public:

    IOModel( const string & name );

    virtual ~IOModel();
    
    virtual void setValue( const string & newVal );
    virtual void setValue( int            newVal );
    virtual void setValue( float          newVal );
    
    virtual void changed();
    
    virtual int            getInt();
    virtual float          getFloat();
    virtual const string & getString();

    virtual void addView( IOView * );
    virtual void remView( IOView * );
    
private:

    IOView * findView( IOView * aView );

    void init();
    void finit();

    list<IOView*> mObservers;
    
};

#endif // _XTV_IO_MODEL_HPP