/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_MANAGER_HPP
#define _XTV_IO_MANAGER_HPP

#include <list>
#include <string>

using namespace std;

/*
    description:
    
    IOManager:
    
        bookeeping of devices like audio/video in-/ouput
        creation of streams, a dataflow path from one device to other(s)
*/

/* forward */ class IOObject;
/* forward */ class IONode;
/* forward */ class IOString;
/* forward */ class IOStream;

class IOManager
{

    public:
    
        static IOManager & instance();
        
        virtual ~IOManager();
        
        bool registerObject ( IOObject  * );
        bool registerNode   ( IONode    * );
        bool registerStream ( IOStream  * );

        bool unregisterObject ( IOObject  * );
        bool unregisterNode   ( IONode    * );
        bool unregisterStream ( IOStream  * );
        
        IONode    * openNode  ( const string  & name, int minor = -1 );
        IOStream  * openStream( const string  & name );

        void        closeNode  ( IONode   * );
        void        closeStream( IOStream * );
        
        typedef list<IOObject*> ObjectList;
        typedef list<IONode*>   DeviceList;
        typedef list<IOStream*> StreamList;
        typedef list<IOString*> StringList;

        virtual bool sendCommand( const string & nodeName, const string & command, 
                                  const string & param1 = "", const string & param2 = "", 
                                  const string & param3 = "", const string & param4 = "" );

        virtual string getValue( const string & nodeName, const string & valueName );
        
        virtual void setAlias( const string & realName, const string & aliasName );

        IOObject *  findObject( const string & aName );
        IONode   *  findNode  ( const string & aName, int minor = -1 );
        IOStream *  findStream( const string & aName );
        IOString *  findAlias ( const string & aName );

        DeviceList & getDeviceList();
        
        void start();
        void stop();
        
    private:

        // disable default copy/construction
        
    protected: // just to avoid compiler warnings , should be private
    
        IOManager();

        IOManager( const IOManager & );

        virtual void operator=(const IOManager & );

        void LoadPlugin(  const string & path, const string & name );

    private:
    
        // members
        
        ObjectList mObjects;
        DeviceList mDevices;
        StreamList mStreams;
        StringList mAliases;

        void  init();
        void finit();
};

extern "C" int initIO( int argc, const char ** argv );

#endif // _XTV_IO_MANAGER_HPP