/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_HARDWARE_HPP
#define _XTV_IO_HARDWARE_HPP

/*
 *  Audio.h
 *  xtv
 *
 *  Created by andi on Wed Oct 10 2001.
 *
 */

#include <IO/Manager/IODictionary.hpp>
#include <IO/Manager/IONode.hpp>


class IODescription : public IOObject {
    
    public:
     
        enum IODirection { ioIn, ioOut, ioInOut };
    
        IODescription( const string & aName );
        IODescription( const IODescription & );

        void operator=(const IODescription & );
    
        void setName     ( const string &  );
        void setDirection( IODirection );
        void setDeviceID ( IODeviceID );
        
        IODirection    getDirection() const;
        const string & getName() const;
        IODeviceID     getDeviceID() const;
        
    private:
    
        IODirection mDirection;
        string      mName;
        IODeviceID  mDeviceID;
    };

class IOHardware : public IOObject {

public:

    IOHardware( const string & aName );
    
    virtual ~IOHardware();
    
    typedef IODictionary List;
    
    virtual List& getList();
    
protected:

    virtual void updateDeviceList() = 0;

    List mDeviceList;
    
    void init();
    void finit();
    
};

#endif // _XTV_IO_HARDWARE_HPP