/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IOHardware.hpp>


IODescription::IODescription( const string & aName )
 : IOObject( aName, "IODescription" )
{
}

IODescription::IODescription( const IODescription & x )
 : IOObject( x.mName, "IODescription" )
{
    (*this) = x;
}

void IODescription::operator=(const IODescription & x )
{
    mName      = x.mName;
    mDeviceID  = x.mDeviceID;
    mDirection = x.mDirection;
}
    
void IODescription::setName( const string & aName )
{
    mName = aName;
}

void IODescription::setDirection( IODirection aDirection )
{
    mDirection = aDirection;
}

void IODescription::setDeviceID( IODeviceID anID )
{
    mDeviceID = anID;
}

IODescription::IODirection IODescription::getDirection() const
{
    return mDirection;
}

const string & IODescription::getName() const
{
    return mName;
}

IODeviceID IODescription::getDeviceID() const
{
    return mDeviceID;
}

IOHardware::IOHardware( const string & aName )
 : IOObject( aName, "IOHardware" ), mDeviceList("IODeviceList")
{
    init();
}

IOHardware::~IOHardware()
{
    finit();
}

IOHardware::List & IOHardware::getList()
{
    mDeviceList.clear();

    updateDeviceList();
    
    return mDeviceList;
}

void IOHardware::init()
{
}

void IOHardware::finit()
{
    mDeviceList.clear();
}
        
