/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_DICTIONARY_HPP
#define _XTV_IO_DICTIONARY_HPP

#include <IO/Manager/IOObject.hpp>
#include <list>

/*
    description:
    
    IODictionary:
    
*/


class IODictionary : public IOObject
{

    public:

        IODictionary( const string & aName );

        virtual ~IODictionary();
                    

        virtual bool append( IOObject * );
        virtual bool remove( IOObject * );
        
        typedef list<IOObject*>     List;
        typedef  List::iterator     Iterator;
        
        virtual Iterator begin();
        virtual Iterator end  ();

        virtual size_t size() const;
        virtual void clear();

    protected:
    

    private:
    
         List mList;       


        void  init();
        void finit();
};

#endif // _XTV_IO_DICTIONARY_HPP