/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IODictionary.hpp>

IODictionary::IODictionary( const string & aName )
 : IOObject( aName, "IODictionary" )
{
    init();
}

IODictionary::~IODictionary()
{
    finit();
}
                    
void IODictionary::init()
{
}

void IODictionary::finit()
{
    clear();
}

void IODictionary::clear()
{
    lock();
    
    while( size() ) {
    
        IOObject * n = mList.front();
    
        mList.pop_front();
        
        n->release();
    }
    
    unlock();
}

size_t IODictionary::size() const
{
    return mList.size();
}

bool IODictionary::append( IOObject * obj )
{
    lock();

    mList.push_back( obj );

    unlock();

    return true;
}
 
bool IODictionary::remove( IOObject * )
{
    lock();

    unlock();

    return true;
}
        
IODictionary::Iterator IODictionary::begin() 
{
    return mList.begin();
}

IODictionary::Iterator IODictionary::end() 
{
    return mList.end();
}
